"use strict";

// Class Definition
var KTLogin = function() {
    var _login;

    var _showForm = function(form) {
        var cls = 'login-' + form + '-on';
        var form = 'kt_login_' + form + '_form';

        _login.removeClass('login-forgot-on');
        _login.removeClass('login-signin-on');
        _login.removeClass('login-signup-on');

        _login.addClass(cls);

        KTUtil.animateClass(KTUtil.getById(form), 'animate__animated animate__backInUp');
    }

    var _handleSignInForm = function() {
        var validation;

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        validation = FormValidation.formValidation(
			KTUtil.getById('kt_login_signin_form'),
			{
				fields: {
					username: {
						validators: {
							notEmpty: {
								message: 'وارد کردن نام کاربری اجباری است'
							}
						}
					},
					password: {
						validators: {
							notEmpty: {
								message: 'وارد کردن کلمه عبور اجباری است'
							}
						}
					}
				},
				plugins: {
                    trigger: new FormValidation.plugins.Trigger(),
                    submitButton: new FormValidation.plugins.SubmitButton(),
                    //defaultSubmit: new FormValidation.plugins.DefaultSubmit(), // Uncomment this line to enable normal button submit after form validation
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		);

       $('#kt_login_signin_submit').on('click', function (e) {
   			 e.preventDefault();

    // فرض می‌کنیم `validation` یک متغیر معتبر است که متد `validate` دارد
    validation.validate().then(function (status) {
        if (status === 'Valid') {
            Swal.fire({
                text: "همه چیز به درستی انجام شد! اکنون می‌توانید فرم را ارسال کنید.",
                icon: "success",
                buttonsStyling: false,
                confirmButtonText: "باشه، متوجه شدم!",
                customClass: {
                    confirmButton: "btn font-weight-bold btn-light-primary"
                }
            }).then(function () {
                KTUtil.scrollTop(); // بازگشت به بالای صفحه
                $('#kt_login_signin_form').submit(); // ارسال فرم
            });
        } else {
            Swal.fire({
                text: "با عرض پوزش، برخی از خطاها شناسایی شده‌اند. لطفاً دوباره بررسی کنید.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "باشه، متوجه شدم!",
                customClass: {
                    confirmButton: "btn font-weight-bold btn-light-primary"
                }
            }).then(function () {
                KTUtil.scrollTop(); // بازگشت به بالای صفحه
            });
        }
    }).catch(function (error) {
        console.error("خطا در اعتبارسنجی:", error);
        Swal.fire({
            text: "مشکلی رخ داده است. لطفاً دوباره تلاش کنید.",
            icon: "error",
            buttonsStyling: false,
            confirmButtonText: "باشه، متوجه شدم!",
            customClass: {
                confirmButton: "btn font-weight-bold btn-light-primary"
            }
        });
    });
});


        // Handle forgot button
        $('#kt_login_forgot').on('click', function (e) {
            e.preventDefault();
            _showForm('forgot');
        });

        // Handle signup
        $('#kt_login_signup').on('click', function (e) {
            e.preventDefault();
            _showForm('signup');
        });
    }

    var _handleSignUpForm = function(e) {
        var validation;
        var form = KTUtil.getById('kt_login_signup_form');

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        validation = FormValidation.formValidation(
			form,
			{
				fields: {
					fullname: {
						validators: {
							notEmpty: {
								message: 'وارد کردن نام کاربری اجباری است'
							}
						}
					},
					email: {
                        validators: {
							notEmpty: {
								message: 'آدرس ایمیل لازم است'
							},
                            emailAddress: {
								message: "مقدار یک آدرس ایمیل معتبر نیست"
							}
						}
					},
                    password: {
                        validators: {
                            notEmpty: {
                                message: 'The password is required'
                            }
                        }
                    },
                    cpassword: {
                        validators: {
                            notEmpty: {
                                message: "تأیید رمز عبور لازم است"
                            },
                            identical: {
                                compare: function() {
                                    return form.querySelector('[name="password"]').value;
                                },
                                message: "رمز عبور و تأیید آن یکسان نیستند"
                            }
                        }
                    },
                    agree: {
                        validators: {
                            notEmpty: {
                                message: 'شما باید قوانین و ضوابط را بپذیرید'
                            }
                        }
                    },
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		);

        $('#kt_login_signup_submit').on('click', function (e) {
            e.preventDefault();

            validation.validate().then(function(status) {
		        if (status == 'Valid') {
                    swal.fire({
		                text: "همه چیز جالب است! اکنون این فرم را ارسال می کنید",
		                icon: "success",
		                buttonsStyling: false,
		                confirmButtonText: "باشه فهمیدم!",
                        customClass: {
    						confirmButton: "btn font-weight-bold btn-light-primary"
    					}
		            }).then(function() {
						KTUtil.scrollTop();
					});
				} else {
					swal.fire({
		                text: "با عرض پوزش ، به نظر می رسد برخی از خطاها شناسایی شده اند ، لطفا دوباره امتحان کنید.",
		                icon: "error",
		                buttonsStyling: false,
		                confirmButtonText: "باشه فهمیدم!",
                        customClass: {
    						confirmButton: "btn font-weight-bold btn-light-primary"
    					}
		            }).then(function() {
						KTUtil.scrollTop();
					});
				}
		    });
        });

        // Handle cancel button
        $('#kt_login_signup_cancel').on('click', function (e) {
            e.preventDefault();

            _showForm('signin');
        });
    }

    var _handleForgotForm = function(e) {
        var validation;

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        validation = FormValidation.formValidation(
			KTUtil.getById('kt_login_forgot_form'),
			{
				fields: {
					email: {
						validators: {
							notEmpty: {
								message: 'آدرس ایمیل لازم است'
							},
                            emailAddress: {
								message: "مقدار یک آدرس ایمیل معتبر نیست"
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap()
				}
			}
		);

        // Handle submit button


		
        $('#kt_login_forgot_submit').on('click', function (e) {
            	e.preventDefault();

				
            validation.validate().then(function(status) {
		        if (status == 'Valid') {
                    // Submit form
                    KTUtil.scrollTop();
				} else {
					swal.fire({
		                text: "با عرض پوزش ، به نظر می رسد برخی از خطاها شناسایی شده اند ، لطفا دوباره امتحان کنید.",
		                icon: "error",
		                buttonsStyling: false,
		                confirmButtonText: "باشه فهمیدم!",
                        customClass: {
    						confirmButton: "btn font-weight-bold btn-light-primary"
    					}
		            }).then(function() {
						KTUtil.scrollTop();
					});
				}
		    });
        });

        // Handle cancel button
        $('#kt_login_forgot_cancel').on('click', function (e) {
            e.preventDefault();

            _showForm('signin');
        });
    }

    // Public Functions
    return {
        // public functions
        init: function() {
            _login = $('#kt_login');

            _handleSignInForm();
            _handleSignUpForm();
            _handleForgotForm();
        }
    };
}();

// Class Initialization
jQuery(document).ready(function() {
    KTLogin.init();
});
