# Generated by Django 4.2 on 2025-02-12 14:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_jalali.db.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='DateHalfMonth',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=105, verbose_name='عنوان')),
                ('start_date', django_jalali.db.models.jDateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='تاریخ شروع')),
                ('end_date', django_jalali.db.models.jDateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='تاریخ پایان')),
            ],
            options={
                'verbose_name': 'بازه زمانی',
                'verbose_name_plural': 'بازه\u200cهای زمانی',
            },
        ),
        migrations.CreateModel(
            name='DateHalfyear',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=105, verbose_name='عنوان')),
                ('start_date', django_jalali.db.models.jDateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='تاریخ شروع')),
                ('end_date', django_jalali.db.models.jDateField(blank=True, default=django.utils.timezone.now, null=True, verbose_name='تاریخ پایان')),
            ],
            options={
                'verbose_name': 'بازه زمانی',
                'verbose_name_plural': 'بازه\u200cهای زمانی',
            },
        ),
        migrations.CreateModel(
            name='Index',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=55, verbose_name='عنوان')),
                ('coefficient', models.IntegerField(verbose_name='ضریب')),
            ],
            options={
                'verbose_name': 'شاخصه',
                'verbose_name_plural': 'مشخصات',
            },
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('national_code', models.CharField(max_length=10, unique=True, verbose_name='کدملی')),
            ],
            options={
                'verbose_name': 'شخص',
                'verbose_name_plural': 'اشخاص',
            },
        ),
        migrations.CreateModel(
            name='ReportCard',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, choices=[('فرهنگی', 'فرهنگی'), ('مستمر', 'مستمر'), ('نهایی', 'نهایی')], max_length=100, null=True, verbose_name='عنوان کارنامه')),
                ('average_score', models.FloatField(blank=True, default=0, null=True, verbose_name='میانگین نمرات')),
                ('date', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='persons.datehalfyear', verbose_name='تاریخ')),
                ('person', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='reportcards', to='persons.person', verbose_name='شخص')),
            ],
            options={
                'verbose_name': 'کارنامه',
                'verbose_name_plural': 'کارنامه\u200cها',
                'ordering': ['-date__start_date'],
            },
        ),
        migrations.CreateModel(
            name='Ring',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alternative', models.CharField(blank=True, max_length=150, null=True, verbose_name='جانشین حلقه')),
                ('name', models.CharField(max_length=150, verbose_name='نام حلقه')),
                ('typee', models.CharField(choices=[('مربیان', 'مربیان'), ('سرگروهین', 'سرگروهین'), ('رابط', 'رابط')], max_length=20, verbose_name='نوع حلقه')),
                ('major', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='rings_major', to='persons.person', verbose_name='(سرگروه)مسئول')),
            ],
            options={
                'verbose_name': 'حلقه',
                'verbose_name_plural': 'حلقه\u200cها',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('ادمین_اصلی', 'ادمین_اصلی'), ('فرماندهی', 'فرماندهی'), ('اعضای_کانون', 'اعضای_کانون'), ('نیرو_انسانی', 'نیرو_انسانی'), ('امام_جماعت', 'امام_جماعت'), ('ورزشی_و_اردویی', 'ورزشی_و_اردویی'), ('تعلیم_و_تربیت', 'تعلیم_و_تربیت'), ('علمی_و_آموزشی', 'علمی_و_آموزشی'), ('حفاظت', 'حفاظت'), ('سرگروه', 'سرگروه'), ('خانواده', 'خانواده'), ('اعضای_شورا', 'اعضای_شورا')], max_length=50, verbose_name='عنوان (نام)')),
                ('description', models.TextField(blank=True, null=True, verbose_name='توضیحات')),
                ('can_views_self', models.BooleanField(default=False, verbose_name='دیدن اطلاعات خود؟')),
                ('can_views_ReportCard', models.BooleanField(default=False, verbose_name='دیدن کارنامه خود؟')),
                ('can_views_users', models.BooleanField(default=False, verbose_name='دیدن اطلاعات کاربران؟')),
                ('can_add_user', models.BooleanField(default=False, verbose_name='اضافه کردن کاربر؟')),
                ('can_edit_user', models.BooleanField(default=False, verbose_name='ویرایش کردن کاربر؟')),
                ('can_delete_user', models.BooleanField(default=False, verbose_name='حذف کردن کاربر؟')),
                ('can_define_roles', models.BooleanField(default=False, verbose_name='تعریف کردن نقش؟')),
                ('can_add_ReportCard', models.BooleanField(default=False, verbose_name='اضافه کردن کارنامه؟')),
                ('can_Cold_storage', models.BooleanField(default=False, verbose_name='اعطا سردوشی؟')),
                ('can_task', models.BooleanField(default=False, verbose_name='اضافه کردن ماموریت؟')),
                ('can_add_ring', models.BooleanField(default=False, verbose_name='اضافه کردن حلقه؟')),
            ],
            options={
                'verbose_name': 'نقش',
                'verbose_name_plural': 'نقش ها',
            },
        ),
        migrations.CreateModel(
            name='RingMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('person', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to='persons.person', verbose_name='اعضا')),
                ('ring', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to='persons.ring', verbose_name='حلقه')),
            ],
            options={
                'verbose_name': 'عضو حلقه',
                'verbose_name_plural': 'اعضاحلقه',
            },
        ),
        migrations.CreateModel(
            name='ReportCardFinaly',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', django_jalali.db.models.jDateField(auto_now_add=True, verbose_name='تاریخ ایجاد')),
                ('sargroh', models.IntegerField(blank=True, null=True)),
                ('talimvatarbiat', models.IntegerField(blank=True, null=True)),
                ('elmivaamozeshi', models.IntegerField(blank=True, null=True)),
                ('varzeshivaordoee', models.IntegerField(blank=True, null=True)),
                ('syasatgozari', models.IntegerField(blank=True, null=True)),
                ('farmandehi', models.IntegerField(blank=True, null=True)),
                ('emamjamaat', models.IntegerField(blank=True, null=True)),
                ('upgrade_used', models.BooleanField(default=False, verbose_name='آیا ارتقاء استفاده شده است؟')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='final_report_cards', to='persons.person', verbose_name='شخص')),
                ('title', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fainaly', to='persons.reportcard', verbose_name='عنوان')),
            ],
            options={
                'verbose_name': 'کارنامه نهایی',
                'verbose_name_plural': ' کارنامه های نهایی  ',
            },
        ),
        migrations.CreateModel(
            name='ReportCardDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('score', models.IntegerField(verbose_name='نمره')),
                ('date_created', django_jalali.db.models.jDateField(blank=True, null=True, verbose_name='تاریخ ایجاد')),
                ('signature', models.ImageField(blank=True, null=True, upload_to='signature')),
                ('index', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='persons.index', verbose_name='شاخصه')),
                ('reportcard', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='details', to='persons.reportcard', verbose_name='کارنامه')),
            ],
            options={
                'verbose_name': 'کارنامه جزعیات فرهنگی ',
                'verbose_name_plural': 'کارنامه جزعیات فرهنگی ',
            },
        ),
        migrations.AddField(
            model_name='reportcard',
            name='ring',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='persons.ring', verbose_name='حلقه\u200cمربوطه'),
        ),
        migrations.CreateModel(
            name='PersonPrivateInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pic', models.ImageField(blank=True, null=True, upload_to='media/persons/', verbose_name='تصویر')),
                ('birthday', django_jalali.db.models.jDateField(max_length=10, verbose_name='تاریخ تولد*')),
                ('birth_place', models.CharField(blank=True, default='کرج', max_length=100, null=True, verbose_name='محل تولد')),
                ('gender', models.CharField(blank=True, choices=[('آقا', 'آقا'), ('خانم', 'خانم')], default='آقا', max_length=10, null=True, verbose_name='جنسیت')),
                ('phone', models.CharField(blank=True, default='-', max_length=11, null=True, verbose_name='شماره موبایل')),
                ('father_name', models.CharField(max_length=110, verbose_name='نام پدر')),
                ('father_phone', models.CharField(blank=True, default='-', max_length=11, null=True, verbose_name='شماره تماس پدر')),
                ('fatherIsAlive', models.CharField(blank=True, choices=[('بله', 'بله'), ('خیر', 'خیر')], default='بله', max_length=10, null=True, verbose_name='پدر در قید حیات است؟')),
                ('father_grade', models.CharField(blank=True, choices=[('زیر سیکل', 'زیر سیکل'), ('سیکل', 'سیکل'), ('دیپلم', 'دیپلم'), ('فوق دیپلم', 'فوق دیپلم'), ('لیسانس', 'لیسانس'), ('فوق لیسانس', 'فوق لیسانس'), ('دکتری', 'دکتری')], default='-', max_length=100, null=True, verbose_name='تحصیلات پدر')),
                ('fatherJob', models.CharField(blank=True, default='-', max_length=150, null=True, verbose_name='شغل پدر')),
                ('motherIsAlive', models.CharField(blank=True, choices=[('بله', 'بله'), ('خیر', 'خیر')], default='بله', max_length=10, null=True, verbose_name='مادر در قید حیات است؟')),
                ('mother_phone', models.CharField(blank=True, default='-', max_length=11, null=True, verbose_name='شماره تماس مادر')),
                ('mother_name', models.CharField(blank=True, default='-', max_length=150, null=True, verbose_name='نام و نام خانوادگی مادر')),
                ('mother_grade', models.CharField(blank=True, choices=[('زیر سیکل', 'زیر سیکل'), ('سیکل', 'سیکل'), ('دیپلم', 'دیپلم'), ('فوق دیپلم', 'فوق دیپلم'), ('لیسانس', 'لیسانس'), ('فوق لیسانس', 'فوق لیسانس'), ('دکتری', 'دکتری')], default='-', max_length=100, null=True, verbose_name='تحصیلات مادر')),
                ('motherJob', models.CharField(blank=True, default='-', max_length=150, null=True, verbose_name='شغل مادر')),
                ('person', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='person_private_info', to='persons.person', verbose_name='کاربر')),
            ],
            options={
                'verbose_name': 'اطلاعات شخصی',
                'verbose_name_plural': 'اطلاعات شخصی',
            },
        ),
        migrations.CreateModel(
            name='PersonOtherInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('family_count', models.IntegerField(blank=True, null=True, verbose_name='تعداد اعضای خانواده')),
                ('numberOfChild', models.IntegerField(blank=True, null=True, verbose_name='فرزند چندم')),
                ('wife_type', models.CharField(choices=[('مجرد', 'مجرد'), ('متاهل', 'متاهل')], default='مجرد', max_length=10, verbose_name='وضعیت تاهل')),
                ('is_employed', models.CharField(blank=True, choices=[('بله', 'بله'), ('خیر', 'خیر')], default='خیر', max_length=10, null=True, verbose_name='شاغل است؟')),
                ('job_type', models.CharField(blank=True, default='آزاد', max_length=50, null=True, verbose_name='نوع شغل')),
                ('job_title', models.CharField(blank=True, default='-', max_length=250, null=True, verbose_name='عنوان شغل')),
                ('salary_month', models.IntegerField(blank=True, null=True, verbose_name='میزان درآمد ماهانه(تومان)')),
                ('talents', models.TextField(blank=True, default='-', null=True, verbose_name='استعداد و توانایی ها')),
                ('person', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='person_other_info', to='persons.person', verbose_name='کاربر')),
            ],
            options={
                'verbose_name': 'اطلاعات تکمیلی',
                'verbose_name_plural': 'اطلاعات تکمیلی',
            },
        ),
        migrations.CreateModel(
            name='PersonEDU',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('typee', models.CharField(choices=[('نامعلوم', 'نامعلوم'), ('ترک\u200c تحصیل', 'ترک\u200c تحصیل'), ('دانش\u200cآموز', 'دانش\u200cآموز'), ('دانشجو', 'دانشجو'), ('طلبه', 'طلبه'), ('فارغ التحصیل', 'فارغ التحصیل')], default='نامعلوم', max_length=20, verbose_name='وضعیت تحصیلی')),
                ('place_name', models.CharField(blank=True, default='-', max_length=250, null=True, verbose_name='نام محل تحصیل')),
                ('edu_name', models.CharField(blank=True, default='-', max_length=250, null=True, verbose_name='رشته تحصیلی')),
                ('term_name', models.CharField(blank=True, default='-', max_length=250, null=True, verbose_name='ترم/پایه تحصیلی')),
                ('otherClass', models.TextField(blank=True, default='-', max_length=300, null=True, verbose_name='کلاس خارج از مدرسه')),
                ('place_address', models.TextField(blank=True, default='-', null=True, verbose_name='آدرس محل تحصیل')),
                ('person', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='person_edu', to='persons.person', verbose_name='کاربر')),
            ],
            options={
                'verbose_name': 'مشخصات\u200c تحصیلی',
                'verbose_name_plural': 'مشخصات\u200c تحصیلی',
            },
        ),
        migrations.CreateModel(
            name='PersonCultural',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('raste_categories', models.CharField(blank=True, choices=[('ورزشی و اردویی', 'ورزشی و اردویی'), ('هییت', 'هییت'), ('مالی', 'مالی'), ('فرهنگی', 'فرهنگی'), ('علمی و آموزشی', 'علمی و آموزشی'), ('حفا', 'حفا'), ('تعلیم و تربیت', 'تعلیم و تربیت'), ('اداری', 'اداری'), ('اجتماعی', 'اجتماعی'), ('عملیات', 'عملیات')], default='اداری', max_length=20, null=True, verbose_name='رسته')),
                ('ozviat_categories', models.CharField(blank=True, choices=[('عادی', 'عادی'), ('فعال', 'فعال'), ('کادر', 'کادر')], default='عادی', max_length=20, null=True, verbose_name='عضویت')),
                ('tarbyat_categories', models.CharField(blank=True, choices=[('رابط', 'رابط'), ('سرگروه', 'سرگروه'), ('مربی', 'مربی')], default='رابط', max_length=20, null=True, verbose_name='رده\u200cتربیتی')),
                ('sardoshi_categories', models.CharField(blank=True, choices=[('محب', 'محب'), ('صابر', 'صابر'), ('خادم', 'خادم'), ('جاهد', 'جاهد'), ('معین', 'معین'), ('شاهد', 'شاهد')], default='محب', max_length=20, null=True, verbose_name='سردوشی')),
                ('date_enter', django_jalali.db.models.jDateField(blank=True, null=True, verbose_name='تاریخ ورود به مسجد')),
                ('Psychological_test', models.ImageField(blank=True, default='-', null=True, upload_to='media/Psychological_test/', verbose_name='نتیجه تست')),
                ('first_major_name', models.CharField(blank=True, default='-', max_length=100, null=True, verbose_name='نام اولین مربی')),
                ('enter_type', models.CharField(blank=True, default='-', max_length=100, null=True, verbose_name='نحوه جذب')),
                ('description', models.TextField(blank=True, default='-', null=True, verbose_name='توضیحات')),
                ('person', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='person_cultural', to='persons.person', verbose_name='کاربر')),
            ],
            options={
                'verbose_name': 'مشخصات\u200c فرهنگی',
                'verbose_name_plural': 'مشخصات\u200c فرهنگی',
            },
        ),
        migrations.CreateModel(
            name='PersonAddress',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('typee', models.CharField(choices=[('محل سکونت', 'محل سکونت'), ('محل کار', 'محل کار'), ('محل کار پدر', 'محل کار پدر')], default='محل سکونت', max_length=100, verbose_name='عنوان آدرس')),
                ('address', models.CharField(blank=True, default='-', max_length=250, null=True, verbose_name='آدرس')),
                ('postal_code', models.CharField(blank=True, default='-', max_length=10, null=True, verbose_name='کدپستی')),
                ('tell', models.CharField(blank=True, default='-', max_length=11, null=True, verbose_name='تلفن ثابت')),
                ('location', models.CharField(blank=True, default='-', max_length=250, null=True, verbose_name='موقعیت')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='person_address', to='persons.person', verbose_name='کاربر')),
            ],
            options={
                'verbose_name': 'آدرس',
                'verbose_name_plural': 'آدرس\u200cها',
            },
        ),
        migrations.AddField(
            model_name='person',
            name='role',
            field=models.ManyToManyField(to='persons.role', verbose_name='نقش'),
        ),
        migrations.AddField(
            model_name='person',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='کاربر'),
        ),
        migrations.AddField(
            model_name='index',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='persons.role', verbose_name='نقش'),
        ),
        migrations.CreateModel(
            name='Family',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('score', models.IntegerField(blank=True, null=True)),
                ('child', models.ManyToManyField(related_name='child_family', to='persons.person', verbose_name='نام فرزند')),
                ('individual', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='individual_family', to='persons.person', verbose_name='شخص')),
            ],
            options={
                'verbose_name': 'خانواده',
                'verbose_name_plural': ' خانواده ها ',
            },
        ),
    ]
