from django.contrib import admin
from .models import *
from jalali_date.admin import ModelAdminJalaliMixin

admin.site.register(Role)
admin.site.register(Index)
admin.site.register(DateHalfMonth)
admin.site.register(Family)
admin.site.register(ReportCardFinaly)
admin.site.register(ReportCardDetail)




class DateHalfyearAdmin(ModelAdminJalaliMixin, admin.ModelAdmin):
    list_display = ['title', 'start_date', 'end_date']

admin.site.register(DateHalfyear, DateHalfyearAdmin)



class PersonPrivateInfoInline(admin.TabularInline):
    model = PersonPrivateInfo


class PersonAddressInline(admin.TabularInline):
    model = PersonAddress


class PersonCulturalInline(admin.TabularInline):
    model = PersonCultural


class PersonEDUInline(admin.TabularInline):
    model = PersonEDU


class PersonOtherInfoInline(admin.TabularInline):
    model = PersonOtherInfo


class RingMemberInline(admin.TabularInline):
    model = RingMember


class ReportCardDetailInline(admin.TabularInline):
    model = ReportCardDetail


# class ReportCardFinalyInline(admin.TabularInline):
#     model = ReportCardFinaly



@admin.register(Person)
class PersonAdmin(admin.ModelAdmin):
    inlines = [PersonPrivateInfoInline, PersonAddressInline,
               PersonCulturalInline, PersonEDUInline, PersonOtherInfoInline]


@admin.register(Ring)
class RingAdmin(admin.ModelAdmin):
    inlines = [
        RingMemberInline,
    ]


@admin.register(ReportCard)
class ReportCardAdmin(admin.ModelAdmin):
    inlines = [ReportCardDetailInline]
#     list_display = ('title', 'date_display', 'person', 'ring')  # ستون‌های نمایش
#     search_fields = ('title', 'person__name')  # امکان جستجو
#     list_filter = ('title', 'date')  # امکان فیلترگذاری
