import json
import pandas as pd
from .models import *
from .forms import * 
from django.http import JsonResponse
from django.urls import reverse_lazy
# from django_select2.views import AutoResponseView
from django.views.generic import CreateView, UpdateView, DeleteView, ListView,TemplateView , DetailView
from django.shortcuts import render, redirect, get_object_or_404 , redirect
from django.contrib.auth import authenticate, login , logout
from django.views.decorators.csrf import csrf_protect , csrf_exempt
from django.http import HttpResponse
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User
from datetime import datetime
from django.contrib.auth.mixins import LoginRequiredMixin
from django.utils.timezone import now
from persons.models import *
from django.contrib import messages

def council_list(request):
    councils = Council.objects.all()
    return render(request, 'council/council_list.html', {'councils': councils})


def council_detail(request,council_id):
   council = get_object_or_404(Council, id=council_id)
   approvals = CouncilApprovals.objects.filter(council=council)
   return render(request, 'council/council_detail.html', {
        'council': council,
        'approvals': approvals
    })
from django.urls import reverse

def council_add(request):
    if request.method == 'POST':
        form = CouncilForm(request.POST, request.FILES)
        if form.is_valid():
            council = form.save()  
            messages.success(request, 'شورا  با موفقیت اضافه شد.' )

            # مدیریت فایل‌های آپلود شده
            for file in request.FILES.getlist('files'):
                # اینجا می‌توانید فایل‌ها را ذخیره کنید
                pass
            return redirect(reverse('council_approvals', kwargs={'council_id': council.id}))
    else:
        form = CouncilForm()

    return render(request, 'council/council_form.html', {'form': form})


def council_edit(request, pk):
    council = Council.objects.get(pk=pk)
    if request.method == 'POST':
        form = CouncilForm(request.POST, request.FILES, instance=council)
        if form.is_valid():
            form.save()  
            messages.warning(request, 'شورا  با موفقیت ویرایش شد.' )

            return redirect('council_list')
    else:
        form = CouncilForm(instance=council)

    return render(request, 'council/council_form.html', {'form': form, 'council': council})

class CouncilDeleteView(DeleteView):
    model = Council
    template_name = 'council/council_confirm_delete.html'  # مسیر قالب تایید حذف
    success_url = reverse_lazy('council_list')

    
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.error(self.request, 'حلقه  با موفقیت حذف شد.' , extra_tags='danger')
        return super().form_valid(form)
    

def council_approvals(request, council_id):
    council = get_object_or_404(Council, id=council_id)
    approvals = CouncilApprovals.objects.filter(council=council)
    return render(request, 'council/council_approvals_list.html', {
        'council': council,
        'approvals': approvals
    })

class CouncilApprovalsCreateView(CreateView):
    model = CouncilApprovals
    form_class = CouncilApprovalsForm
    template_name = 'council/council_approvals_form.html'
  
    def form_valid(self, form):
        council_id = self.kwargs.get('council_id')
        council = get_object_or_404(Council, id=council_id)
        form.instance.council = council
        messages.success(self.request, 'مصوبه با موفقیت ایجاد شد.')
        return super().form_valid(form)

    def get_success_url(self):
        council_id = self.object.council.id
        return reverse_lazy('council_approvals', kwargs={'council_id': council_id})

# ویرایش مصوبه
class CouncilApprovalsUpdateView(UpdateView):
    model = CouncilApprovals
    form_class = CouncilApprovalsForm
    template_name = 'council/council_approvals_form.html'

    def get_success_url(self):
        council_id = self.object.council.id  # استخراج council_id از شیء مصوبه
        return reverse_lazy('council_approvals', kwargs={'council_id': council_id})  # بازگشت به صفحه مصوبات

    def form_valid(self, form):
        messages.warning(self.request, 'مصوبه  با موفقیت ویرایش شد.' )
        return super().form_valid(form)

class CouncilApprovalsDeleteView(DeleteView):
    model = CouncilApprovals
    template_name = 'council/council_approvals_confirm_delete.html'

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        # استخراج council مربوط به مصوبه
        council = self.object.council
        context['council'] = council
        return context

    def get_success_url(self):
        # استخراج council_id از مدل مصوبه
        council_id = self.object.council.id
        return reverse_lazy('council_approvals', kwargs={'council_id': council_id})

def test(request, person_id):
    # دریافت شخص با استفاده از person_id
    person = get_object_or_404(Person, id=person_id)
    
    # اطلاعات مربوط به شخص
    person_private_info = PersonPrivateInfo.objects.filter(person=person).first()
    person_edu = PersonEDU.objects.filter(person=person).first()
    person_other_info = PersonOtherInfo.objects.filter(person=person).first()
    person_address = PersonAddress.objects.filter(person=person).first()
    person_cultural = PersonCultural.objects.filter(person=person).first()

    context = {
        'person': person,
        'person_private_info': person_private_info,
        'person_edu': person_edu,
        'person_other_info': person_other_info,
        'person_address': person_address,
        'person_cultural': person_cultural
    }
    
    return render(request, 'council/t.html', context)

class CouncilMembersListView(ListView):
    model = Person
    template_name = 'council/council_members_list.html'
    context_object_name = 'members'

    def get_queryset(self):
        council_role = Role.objects.get(name='اعضای_شورا')
        members_with_council_role = Person.objects.filter(role=council_role)
        return members_with_council_role

class CouncilMembersCreateView(CreateView):
    model = CouncilMembers
    form_class = CouncilMembersForm
    template_name = 'council/council_members_form.html'
    success_url = reverse_lazy('council_members_list')

class CouncilMembersUpdateView(UpdateView):
    model = CouncilMembers
    form_class = CouncilMembersForm
    template_name = 'council/council_members_form.html'
    success_url = reverse_lazy('council_members_list')
from django.urls import reverse_lazy
from django.views.generic import DeleteView
from django.shortcuts import redirect
from .models import CouncilMembers
from django.contrib import messages
class CouncilMembersDeleteView(DeleteView):
    model = CouncilMembers
    template_name = 'council/council_members_confirm_delete.html'
    success_url = reverse_lazy('council_members_list')


class FutureworkListView(ListView):
    model = Futurework
    template_name = 'council/futurework_list.html'
    context_object_name = 'futureworks'

class FutureworkCreateView(CreateView ):
    model = Futurework
    form_class = FutureworkForm
    template_name = 'council/futurework_form.html'
    success_url = reverse_lazy('futurework_list')
      
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.success(self.request, 'کار  با موفقیت حذف شد.' )
        return super().form_valid(form)

class FutureworkUpdateView(UpdateView):
    model = Futurework
    form_class = FutureworkForm
    template_name = 'council/futurework_form.html'
    success_url = reverse_lazy('futurework_list')

      
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.warning(self.request, 'کار  با موفقیت ویرایش شد.' )
        return super().form_valid(form)

class FutureworkDeleteView(DeleteView):
    model = Futurework
    template_name = 'council/futurework_confirm_delete.html'
    success_url = reverse_lazy('futurework_list')

    
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.error(self.request, 'کار  با موفقیت حذف شد.' , extra_tags='danger')
        return super().form_valid(form)

def load_titles(request):
    council_id = request.GET.get('council_id')  # دریافت ID شورا
    titles = CouncilApprovals.objects.filter(council_id=council_id).values('id', 'title')
    return JsonResponse(list(titles), safe=False)

def search_persons(request):
    query = request.GET.get('q', '')
    if query:
        # فیلتر بر اساس نام و نام خانوادگی از مدل User
        persons = Person.objects.filter(user__first_name__icontains=query) | Person.objects.filter(user__last_name__icontains=query)
    else:
        persons = Person.objects.none()

    # ارسال داده‌ها به صورت JSON
    data = [{'id': person.id, 'text': f"{person.user.first_name} {person.user.last_name}"} for person in persons]
    return JsonResponse(data, safe=False)

def search_councils(request):
    query = request.GET.get('q', '')
    councils = Council.objects.filter(name__icontains=query)  # فرض بر این است که `Council` مدل شما شامل فیلدی به نام `name` است.
    results = [{'id': council.id, 'text': council.name} for council in councils]
    return JsonResponse(results, safe=False)

class DutiesOfUnitsCreateView(CreateView):
    model = DutiesOfUnits
    form_class = DutiesOfUnitsForm
    template_name = 'activity/duties_of_units_form.html'
    context_object_name = 'duties'

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        # افزودن category از URL به کانتکست
        context['category'] = self.kwargs.get('category')
        return context

    def form_valid(self, form):
        # استخراج مقدار 'category' از آدرس
        category = self.kwargs.get('category')
        if not category:
            messages.error(self.request, 'رسته مشخص نشده است.')
            return redirect('duties_of_units_list')  # هدایت در صورت نبود category

        # مقداردهی 'raste_categories' از آدرس
        form.instance.raste_categories = category
        messages.success(self.request, 'وظیفه با موفقیت اضافه شد.')
        return super().form_valid(form)

    def get_success_url(self):
        # بازگشت به صفحه مرتبط با همان category
        category = self.kwargs.get('category')
        return reverse_lazy('duties_and_activities_by_category', kwargs={'category': category})

class DutiesOfUnitsUpdateView(UpdateView):
    model = DutiesOfUnits
    form_class = DutiesOfUnitsForm
    template_name = 'activity/duties_of_units_form.html'

    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.warning(self.request, 'وظیفه با موفقیت ویرایش شد.')
        # پس از حذف، به URL جدید هدایت می‌شود
        return super().form_valid(form)

    def get_success_url(self):
        # استخراج 'raste_categories' از مدل به کمک self.object
        raste_category = self.object.raste_categories
        # بازگشت به URL جدید با 'raste_category'
        return reverse_lazy('duties_and_activities_by_category', kwargs={'category': raste_category})

class DutiesOfUnitsDeleteView(DeleteView):
    model = DutiesOfUnits
    template_name = 'activity/duties_of_units_confirm_delete.html'

    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.error(self.request, 'وظیفه با موفقیت حذف شد.', extra_tags='danger')
        # پس از حذف، به URL جدید هدایت می‌شود
        return super().form_valid(form)

    def get_success_url(self):
        # استخراج 'raste_categories' از مدل به کمک self.object
        raste_category = self.object.raste_categories
        # بازگشت به URL جدید با 'raste_category'
        return reverse_lazy('duties_and_activities_by_category', kwargs={'category': raste_category})

def activity_details_list(request, main_task_id):
    main_task = get_object_or_404(DutiesOfUnits, pk=main_task_id)
    activities = ActivityDetails.objects.filter(mainTask=main_task)
    return render(request, 'activity/activity_details_list.html', {'main_task': main_task, 'activities': activities})

def activity_details_create(request, main_task_id):
    main_task = get_object_or_404(DutiesOfUnits, pk=main_task_id)  # وظایف اصلی

    if request.method == 'POST':
        form = ActivityDetailsForm(request.POST, main_task=main_task)
        if form.is_valid():
            activity = form.save(commit=False)
            activity.mainTask = main_task  # تنظیم وظایف اصلی
            activity.save()
            messages.success(request, 'ریز فعالیت  با موفقیت اضافه شد.' )

            return redirect(reverse('activity_details_list', kwargs={'main_task_id': main_task_id}))
    else:
        form = ActivityDetailsForm(main_task=main_task)

    return render(request, 'activity/activity_details_form.html', {
        'form': form,
        'main_task': main_task,
    })

def activity_details_update(request, pk):
    # گرفتن ریزفعالیت مورد نظر
    activity = get_object_or_404(ActivityDetails, pk=pk)
    
    if request.method == 'POST':
        # فرم با داده‌های ارسال شده و نمونه موجود پر می‌شود
        form = ActivityDetailsForm(request.POST, instance=activity)
        if form.is_valid():
            form.save() 
            messages.warning(request, 'ریز فعالیت  با موفقیت ویرایش شد.' )

            return redirect('activity_details_list', main_task_id=activity.mainTask.id)
    else:
        # در صورت درخواست GET، فرم با داده‌های موجود پر می‌شود
        form = ActivityDetailsForm(instance=activity)
    
    return render(request, 'activity/activity_details_form.html', {'form': form, 'activity': activity})

def activity_details_delete(request, pk):
    activity = get_object_or_404(ActivityDetails, pk=pk)
    main_task_id = activity.mainTask.id
    if request.method == 'POST':
        activity.delete()
        messages.error(request, 'ریز فعالیت  با موفقیت حذف شد.'  , extra_tags='danger')

        return redirect('activity_details_list', main_task_id=main_task_id)
    return render(request, 'activity/activity_details_confirm_delete.html', {'object': activity})
from django.db.models import Q

def activity_done(request, pk):
    activity = get_object_or_404(ActivityDetails, pk=pk)
    
    if request.method == 'POST':
        description = request.POST.get('description', '')
        time_str = request.POST.get('time', '')

        # تاریخ وارد شده به صورت شمسی ذخیره می‌شود.
        time = time_str  # از تبدیل تاریخ خودداری می‌شود.
        
        # بروزرسانی ویژگی‌های فعالیت
        activity.done = True
        activity.description = description
        activity.time = time  # ذخیره تاریخ شمسی
        activity.save()

        # پیام موفقیت
        messages.success(request, 'ریز فعالیت با موفقیت به فرماندهی ارسال شد.')

        # یافتن کاربران با نقش فرماندهی
        commander_persons =  Person.objects.filter(
    Q(role__name='فرماندهی') | Q(role__name='جانشین')
)

        # ایجاد نوتیفیکیشن
        notification = Notification.objects.create(
            title=f" فعالیت  '{ activity.mainTask.raste_categories}'  انجام شد",
            message=f"ریز فعالیت  '{activity.microActivity}' با موفقیت انجام شد.",
            is_read=False,
            activity_details=activity  # تنظیم فیلد activity_details

        )

        # افزودن تمامی کاربران فرماندهی به نوتیفیکیشن
        for commander in commander_persons:
            notification.user.add(commander.user)
        
        notification.save()  # ذخیره نهایی

    return redirect(f'/meeting/duties/{activity.mainTask.id}/activities')

def notifications_view(request):
    person_instance = request.user.person  # فرض بر این است که هر کاربر یک Person دارد
    notifications = Notification.objects.filter(user=request.user, is_read=False, has_evaluated=False)
    futureworks = Futurework.objects.filter(persons=person_instance, is_read=False)  # فقط کارهای خوانده نشده
    return render(request, 'activity/notifications.html', {'notifications': notifications, 'futureworks': futureworks})
from django.shortcuts import redirect, get_object_or_404
from .models import Futurework

def mark_as_done(request, futurework_id):
    
        futurework = get_object_or_404(Futurework, id=futurework_id)
        futurework.status = "done"
        futurework.is_done = True
        futurework.save()
        return redirect('notifications')  # یا هر صفحه‌ای که می‌خواهید پس از تغییر وضعیت برگردید

def mark_as_in_progress(request, futurework_id):
    futurework = get_object_or_404(Futurework, id=futurework_id)
    futurework.status = "in progress"

    futurework.save()
    return redirect('notifications')  # یا هر صفحه‌ای که می‌خواهید پس از تغییر وضعیت برگردید

def history_dashboard(request):
    notifications = Notification.objects.select_related('activity_details').order_by('-created_at')
    futureworks = Futurework.objects.select_related('title', 'Council').order_by('-created_at')

    context = {
        'notifications': notifications,
        'futureworks': futureworks,
    }
    return render(request, 'activity/history.html', context)

def mark_futurework_read(request, futurework_id):
    try:
        futurework = Futurework.objects.get(id=futurework_id)
        futurework.is_read = True
        futurework.save()
    except Futurework.DoesNotExist:
        pass  # در صورت عدم وجود کار آینده، خطا رخ ندهد
    return redirect('notifications')  # بازگشت به صفحه نوتیفیکیشن‌ها

def activity_not_done(request, pk):
    activity = get_object_or_404(ActivityDetails, pk=pk)
    if request.method == 'POST':
        description = request.POST.get('description', '')
        activity.done = False
        activity.description = description
        activity.time = None  # پاک کردن زمان در صورت انجام‌نشده
        activity.save()
        messages.success(request, 'وضعیت فعالیت به انجام‌نشده تغییر یافت.')
    return redirect(f'/meeting/duties/{activity.mainTask.id}/activities/')

def duties_by_categories_list(request):
    categories = DutiesOfUnits.RASTE_CHOICES
    return render(request, 'activity/duties_by_categories_list.html', {'categories': categories})
def duties_and_activities_by_category(request, category):
    # فیلتر کردن براساس دسته‌بندی انگلیسی
    duties = DutiesOfUnits.objects.filter(raste_categories=category)
    
    # اگر هیچ وظیفه‌ای با این دسته‌بندی پیدا نشد
    if not duties.exists():
        return HttpResponse("Category not found", status=404)

    return render(request, 'activity/duties_and_activities_by_category.html', {
        'duties': duties,
        'category': category,
    })


def duties_of_units_create(request):
    category = request.GET.get('category', None)
    if request.method == 'POST':
        form = DutiesOfUnitsForm(request.POST)
        if form.is_valid():
            form.save()
            return redirect('duties_and_activities_by_category', category=form.cleaned_data['raste_categories'])
    else:
        form = DutiesOfUnitsForm(initial={'raste_categories': category})
    return render(request, 'activity/duties_of_units_form.html', {'form': form})

def submit_evaluation(request, notification_id):
    # بازیابی پیامک
    notification = get_object_or_404(Notification, id=notification_id)

    # بررسی اینکه آیا پیامک به ریزفعالیت مرتبط است
    if not notification.activity_details:
        messages.error(request, 'این پیامک به ریزفعالیتی مرتبط نیست.')
        return redirect('notifications')

    # استخراج وظیفه اصلی و رسته مرتبط
    activity_detail = notification.activity_details
    main_task = activity_detail.mainTask
    raste_category = main_task.raste_categories

    if request.method == 'POST':
        value_choice = request.POST.get('value_choice')
        description = request.POST.get('description', '')

        # بررسی صحت فیلدهای ارسالی
        if not value_choice:
            messages.error(request, 'لطفاً نظر خود را وارد کنید.')
            return redirect('notifications')

        # ذخیره نظر
        Evaluation.objects.create(
            raste_categories=main_task,
            mainTask=activity_detail,
            value_choices=value_choice,
            description=description,
            time=timezone.now(),
        )

        # بروزرسانی وضعیت نوتیفیکیشن
        notification.has_evaluated = True
        notification.save()

        messages.success(request, 'نظر شما با موفقیت ثبت شد.')
        return redirect('notifications')

    return render(
        request,
        'activity/submit_evaluation.html',
        {
            'notification': notification,
            'activity_detail': activity_detail,
            'main_task': main_task,
            'raste_category': raste_category,
        }
    )

class MyDutiesView(LoginRequiredMixin, ListView):
    model = ActivityDetails
    template_name = 'activity/my_duties.html'
    context_object_name = 'activity_details'

    def get_queryset(self):
        person = get_object_or_404(Person, user=self.request.user)
        cultural_info = getattr(person, 'person_cultural', None)

        if not cultural_info:
            return ActivityDetails.objects.none()  # اگر اطلاعات فرهنگی پیدا نشد، هیچ داده‌ای برنگردانیم

        raste = cultural_info.raste_categories  # دریافت رسته شخص

        # فیلتر کردن وظایف اصلی بر اساس رسته
        duties = DutiesOfUnits.objects.filter(raste_categories=raste)

        # فیلتر کردن ریزفعالیت‌ها بر اساس وظایف اصلی
        activity_details = ActivityDetails.objects.filter(mainTask__in=duties)

        # استخراج تنها وظایف اصلی منحصر به فرد
        unique_main_tasks = set(activity_details.values_list('mainTask', flat=True))

        # ایجاد یک لیست از activity_details فقط برای وظایف اصلی منحصر به فرد
        filtered_details = []
        for task in unique_main_tasks:
            filtered_details.append(activity_details.filter(mainTask=task).first())  # اولین ریزفعالیت مربوط به هر وظیفه اصلی

        return filtered_details

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)

        # اضافه کردن اطلاعات رسته به context برای استفاده در قالب
        person = self.request.user.person
        cultural_info = getattr(person, 'person_cultural', None)
        if cultural_info:
            context['raste'] = cultural_info.raste_categories
        else:
            context['raste'] = None  # اگر اطلاعات فرهنگی موجود نبود، رسته را None قرار می‌دهیم

        return context

class SameRasteUsersView(LoginRequiredMixin, ListView):
    model = User
    template_name = 'activity/same_raste_users.html'
    context_object_name = 'same_raste_users'

    def get_queryset(self):
        person = get_object_or_404(Person, user=self.request.user)
        cultural_info = getattr(person, 'person_cultural', None)

        if not cultural_info:
            return User.objects.none()

        raste = cultural_info.raste_categories
        users_with_same_raste = User.objects.filter(person__person_cultural__raste_categories=raste).exclude(id=self.request.user.id)

        return users_with_same_raste

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        person = self.request.user.person
        cultural_info = getattr(person, 'person_cultural', None)

        # اضافه کردن اطلاعات رسته به context
        if cultural_info:
            context['raste'] = cultural_info.raste_categories
            context['sardoshi'] = cultural_info.sardoshi_categories  # اضافه کردن سردوشی به context
        else:
            context['raste'] = None
            context['sardoshi'] = None

        # افزودن اطلاعات تماس و آدرس به context برای هر کاربر
        same_raste_users = context.get('same_raste_users', [])
        users_data = []
        for user in same_raste_users:
            private_info = PersonPrivateInfo.objects.filter(person=user.person).first()  # دریافت اطلاعات شخصی کاربر
            user_phone = private_info.phone if private_info and private_info.phone else 'شماره موبایل موجود نیست'
            user_address = user.person.person_address.first()

            # استخراج اطلاعات تماس و آدرس
            contact_info = {
                'phone': user_phone,
                'address': user_address.address if user_address else 'آدرس موجود نیست',
                'sardoshi': cultural_info.sardoshi_categories if cultural_info else 'سردوشی موجود نیست',  # افزودن سردوشی
            }

            users_data.append({
                'user': user,
                'contact_info': contact_info,
            })

        context['users_data'] = users_data
        return context

@login_required
def evaluations_view(request):
    try:
        # یافتن مسئول واحد بر اساس کاربر
        council_member = CouncilMembers.objects.get(person=request.user.person)
        # نظرات مربوط به واحد مسئول
        evaluations = Evaluation.objects.filter(raste_categories=council_member.raste_categories)
    except CouncilMembers.DoesNotExist:
        # اگر کاربر مسئول واحد نباشد، نظراتی نمایش داده نمی‌شود
        evaluations = []

    return render(request, 'council/evaluations_page.html', {'evaluations': evaluations})




import json
import pandas as pd
from .models import *
from .forms import * 
from django.http import JsonResponse
from django.urls import reverse_lazy
# from django_select2.views import AutoResponseView
from django.views.generic import CreateView, UpdateView, DeleteView, ListView,TemplateView , DetailView
from django.shortcuts import render, redirect, get_object_or_404 , redirect
from django.contrib.auth import authenticate, login , logout
from django.views.decorators.csrf import csrf_protect , csrf_exempt
from django.http import HttpResponse
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User
from datetime import datetime
from django.contrib.auth.mixins import LoginRequiredMixin
from django.utils.timezone import now
from persons.models import *
from django.contrib import messages
from django.db.models import Sum, F, Value, FloatField
from django.db.models.functions import Coalesce
from django.shortcuts import render
def council_list(request):
    councils = Council.objects.all()
    return render(request, 'council/council_list.html', {'councils': councils})
from django.urls import reverse

def council_add(request):
    if request.method == 'POST':
        form = CouncilForm(request.POST, request.FILES)
        if form.is_valid():
            council = form.save()  
            messages.success(request, 'شورا  با موفقیت اضافه شد.' )

            # مدیریت فایل‌های آپلود شده
            for file in request.FILES.getlist('files'):
                # اینجا می‌توانید فایل‌ها را ذخیره کنید
                pass
            return redirect(reverse('council_approvals', kwargs={'council_id': council.id}))
    else:
        form = CouncilForm()

    return render(request, 'council/council_form.html', {'form': form})


def council_edit(request, pk):
    council = Council.objects.get(pk=pk)
    if request.method == 'POST':
        form = CouncilForm(request.POST, request.FILES, instance=council)
        if form.is_valid():
            form.save()  
            messages.warning(request, 'شورا  با موفقیت ویرایش شد.' )

            return redirect('council_list')
    else:
        form = CouncilForm(instance=council)

    return render(request, 'council/council_form.html', {'form': form, 'council': council})

class CouncilDeleteView(DeleteView):
    model = Council
    template_name = 'council/council_confirm_delete.html'  # مسیر قالب تایید حذف
    success_url = reverse_lazy('council_list')

    
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.error(self.request, 'حلقه  با موفقیت حذف شد.' , extra_tags='danger')
        return super().form_valid(form)
    

def council_approvals(request, council_id):
    council = get_object_or_404(Council, id=council_id)
    approvals = CouncilApprovals.objects.filter(council=council)
    return render(request, 'council/council_approvals_list.html', {
        'council': council,
        'approvals': approvals
    })

class CouncilApprovalsCreateView(CreateView):
    model = CouncilApprovals
    form_class = CouncilApprovalsForm
    template_name = 'council/council_approvals_form.html'
  
    def form_valid(self, form):
        council_id = self.kwargs.get('council_id')
        council = get_object_or_404(Council, id=council_id)
        form.instance.council = council
        messages.success(self.request, 'مصوبه با موفقیت ایجاد شد.')
        return super().form_valid(form)

    def get_success_url(self):
        council_id = self.object.council.id
        return reverse_lazy('council_approvals', kwargs={'council_id': council_id})

# ویرایش مصوبه
class CouncilApprovalsUpdateView(UpdateView):
    model = CouncilApprovals
    form_class = CouncilApprovalsForm
    template_name = 'council/council_approvals_form.html'

    def get_success_url(self):
        council_id = self.object.council.id  # استخراج council_id از شیء مصوبه
        return reverse_lazy('council_approvals', kwargs={'council_id': council_id})  # بازگشت به صفحه مصوبات

    def form_valid(self, form):
        messages.warning(self.request, 'مصوبه  با موفقیت ویرایش شد.' )
        return super().form_valid(form)

class CouncilApprovalsDeleteView(DeleteView):
    model = CouncilApprovals
    template_name = 'council/council_approvals_confirm_delete.html'

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        # استخراج council مربوط به مصوبه
        council = self.object.council
        context['council'] = council
        return context

    def get_success_url(self):
        # استخراج council_id از مدل مصوبه
        council_id = self.object.council.id
        return reverse_lazy('council_approvals', kwargs={'council_id': council_id})

def test(request, person_id):
    # دریافت شخص با استفاده از person_id
    person = get_object_or_404(Person, id=person_id)
    
    # اطلاعات مربوط به شخص
    person_private_info = PersonPrivateInfo.objects.filter(person=person).first()
    person_edu = PersonEDU.objects.filter(person=person).first()
    person_other_info = PersonOtherInfo.objects.filter(person=person).first()
    person_address = PersonAddress.objects.filter(person=person).first()
    person_cultural = PersonCultural.objects.filter(person=person).first()

    context = {
        'person': person,
        'person_private_info': person_private_info,
        'person_edu': person_edu,
        'person_other_info': person_other_info,
        'person_address': person_address,
        'person_cultural': person_cultural
    }
    
    return render(request, 'council/t.html', context)

import pandas as pd
from django.http import HttpResponse
from django.shortcuts import get_list_or_404
from .models import CouncilMembers  # مدل مربوطه را جایگزین کنید

def export_selected_members(request):
    if request.method == "POST":
        selected_ids = request.POST.getlist("selected_members")

        if not selected_ids:
            messages.error(request, 'لطفا حداقل یک عضو را انتخاب کنید.')
            return redirect (reverse('council_members_list'))  # یا هر صفحه‌ای که لیست اعضا را نمایش می‌دهد
        members = get_list_or_404(CouncilMembers, pk__in=selected_ids)
        
        data = []
        for member in members:
            data.append({
                "شماره":  member.person.id,
                "نام": member.person.user.first_name,
                 "نام خانوادگی": member.person.user.last_name,  # فیلد را مطابق مدل تغییر دهید
                "رسته": member.raste_categories,
            })

        df = pd.DataFrame(data)
        
        response = HttpResponse(content_type="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")
        response["Content-Disposition"] = "attachment; filename=council_members.xlsx"

        with pd.ExcelWriter(response, engine="xlsxwriter") as writer:
            df.to_excel(writer, index=False, sheet_name="Members")

        return response

    return HttpResponse("درخواست نامعتبر", status=400)

class CouncilMembersCreateView(CreateView):
    model = CouncilMembers
    form_class = CouncilMembersForm
    template_name = 'council/council_members_form.html'
    success_url = reverse_lazy('council_members_list')

class CouncilMembersUpdateView(UpdateView):
    model = CouncilMembers
    form_class = CouncilMembersForm
    template_name = 'council/council_members_form.html'
    success_url = reverse_lazy('council_members_list')

class FutureworkListView(ListView):
    model = Futurework
    template_name = 'council/futurework_list.html'
    context_object_name = 'futureworks'

class FutureworkCreateView(CreateView ):
    model = Futurework
    form_class = FutureworkForm
    template_name = 'council/futurework_form.html'
    success_url = reverse_lazy('futurework_list')
      
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.success(self.request, 'کار  با موفقیت حذف شد.' )
        return super().form_valid(form)

class FutureworkUpdateView(UpdateView):
    model = Futurework
    form_class = FutureworkForm
    template_name = 'council/futurework_form.html'
    success_url = reverse_lazy('futurework_list')

      
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.warning(self.request, 'کار  با موفقیت ویرایش شد.' )
        return super().form_valid(form)

class FutureworkDeleteView(DeleteView):
    model = Futurework
    template_name = 'council/futurework_confirm_delete.html'
    success_url = reverse_lazy('futurework_list')

    
    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.error(self.request, 'کار  با موفقیت حذف شد.' , extra_tags='danger')
        return super().form_valid(form)

def load_titles(request):
    council_id = request.GET.get('council_id')  # دریافت ID شورا
    titles = CouncilApprovals.objects.filter(council_id=council_id).values('id', 'title')
    return JsonResponse(list(titles), safe=False)

def search_persons(request):
    query = request.GET.get('q', '')
    if query:
        # فیلتر بر اساس نام و نام خانوادگی از مدل User
        persons = Person.objects.filter(user__first_name__icontains=query) | Person.objects.filter(user__last_name__icontains=query)
    else:
        persons = Person.objects.none()

    # ارسال داده‌ها به صورت JSON
    data = [{'id': person.id, 'text': f"{person.user.first_name} {person.user.last_name}"} for person in persons]
    return JsonResponse(data, safe=False)

def search_councils(request):
    query = request.GET.get('q', '')
    councils = Council.objects.filter(name__icontains=query)  # فرض بر این است که `Council` مدل شما شامل فیلدی به نام `name` است.
    results = [{'id': council.id, 'text': council.name} for council in councils]
    return JsonResponse(results, safe=False)

class DutiesOfUnitsCreateView(CreateView):
    model = DutiesOfUnits
    form_class = DutiesOfUnitsForm
    template_name = 'activity/duties_of_units_form.html'
    context_object_name = 'duties'

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        # افزودن category از URL به کانتکست
        context['category'] = self.kwargs.get('category')
        return context

    def form_valid(self, form):
        # استخراج مقدار 'category' از آدرس
        category = self.kwargs.get('category')
        if not category:
            messages.error(self.request, 'رسته مشخص نشده است.')
            return redirect('duties_of_units_list')  # هدایت در صورت نبود category

        # مقداردهی 'raste_categories' از آدرس
        form.instance.raste_categories = category
        messages.success(self.request, 'وظیفه با موفقیت اضافه شد.')
        return super().form_valid(form)

    def get_success_url(self):
        # بازگشت به صفحه مرتبط با همان category
        category = self.kwargs.get('category')
        return reverse_lazy('duties_and_activities_by_category', kwargs={'category': category})

class DutiesOfUnitsUpdateView(UpdateView):
    model = DutiesOfUnits
    form_class = DutiesOfUnitsForm
    template_name = 'activity/duties_of_units_form.html'

    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.warning(self.request, 'وظیفه با موفقیت ویرایش شد.')
        # پس از حذف، به URL جدید هدایت می‌شود
        return super().form_valid(form)

    def get_success_url(self):
        # استخراج 'raste_categories' از مدل به کمک self.object
        raste_category = self.object.raste_categories
        # بازگشت به URL جدید با 'raste_category'
        return reverse_lazy('duties_and_activities_by_category', kwargs={'category': raste_category})

class DutiesOfUnitsDeleteView(DeleteView):
    model = DutiesOfUnits
    template_name = 'activity/duties_of_units_confirm_delete.html'

    def form_valid(self, form):
        # ثبت پیام موفقیت
        messages.error(self.request, 'وظیفه با موفقیت حذف شد.', extra_tags='danger')
        # پس از حذف، به URL جدید هدایت می‌شود
        return super().form_valid(form)

    def get_success_url(self):
        # استخراج 'raste_categories' از مدل به کمک self.object
        raste_category = self.object.raste_categories
        # بازگشت به URL جدید با 'raste_category'
        return reverse_lazy('duties_and_activities_by_category', kwargs={'category': raste_category})

def activity_details_list(request, main_task_id):
    main_task = get_object_or_404(DutiesOfUnits, pk=main_task_id)
    activities = ActivityDetails.objects.filter(mainTask=main_task)
    return render(request, 'activity/activity_details_list.html', {'main_task': main_task, 'activities': activities})

def activity_details_create(request, main_task_id):
    main_task = get_object_or_404(DutiesOfUnits, pk=main_task_id)  # وظایف اصلی

    if request.method == 'POST':
        form = ActivityDetailsForm(request.POST, main_task=main_task)
        if form.is_valid():
            activity = form.save(commit=False)
            activity.mainTask = main_task  # تنظیم وظایف اصلی
            activity.save()
            messages.success(request, 'ریز فعالیت  با موفقیت اضافه شد.' )

            return redirect(reverse('activity_details_list', kwargs={'main_task_id': main_task_id}))
    else:
        form = ActivityDetailsForm(main_task=main_task)

    return render(request, 'activity/activity_details_form.html', {
        'form': form,
        'main_task': main_task,
    })

def activity_details_update(request, pk):
    # گرفتن ریزفعالیت مورد نظر
    activity = get_object_or_404(ActivityDetails, pk=pk)
    
    if request.method == 'POST':
        # فرم با داده‌های ارسال شده و نمونه موجود پر می‌شود
        form = ActivityDetailsForm(request.POST, instance=activity)
        if form.is_valid():
            form.save() 
            messages.warning(request, 'ریز فعالیت  با موفقیت ویرایش شد.' )

            return redirect('activity_details_list', main_task_id=activity.mainTask.id)
    else:
        # در صورت درخواست GET، فرم با داده‌های موجود پر می‌شود
        form = ActivityDetailsForm(instance=activity)
    
    return render(request, 'activity/activity_details_form.html', {'form': form, 'activity': activity})

def activity_details_delete(request, pk):
    activity = get_object_or_404(ActivityDetails, pk=pk)
    main_task_id = activity.mainTask.id
    if request.method == 'POST':
        activity.delete()
        messages.error(request, 'ریز فعالیت  با موفقیت حذف شد.'  , extra_tags='danger')

        return redirect('activity_details_list', main_task_id=main_task_id)
    return render(request, 'activity/activity_details_confirm_delete.html', {'object': activity})

def activity_done(request, pk):
    activity = get_object_or_404(ActivityDetails, pk=pk)
    
    if request.method == 'POST':
        description = request.POST.get('description', '')
        time_str = request.POST.get('time', '')

        # تاریخ وارد شده به صورت شمسی ذخیره می‌شود.
        time = time_str  # از تبدیل تاریخ خودداری می‌شود.
        
        # بروزرسانی ویژگی‌های فعالیت
        activity.done = True
        activity.description = description
        activity.time = time  # ذخیره تاریخ شمسی
        activity.save()

        # پیام موفقیت
        messages.success(request, 'ریز فعالیت با موفقیت به فرماندهی ارسال شد.')

        # یافتن کاربران با نقش فرماندهی
        commander_persons =  Person.objects.filter(
    Q(role__name='فرماندهی') | Q(role__name='جانشین')
)
        category_fa = dict(DutiesOfUnits.RASTE_CHOICES).get(activity.mainTask.raste_categories, "نامشخص")

        # ایجاد نوتیفیکیشن
        notification = Notification.objects.create(
            title = f" فعالیت '{category_fa}' انجام شد",
            message=f"ریز فعالیت  '{activity.microActivity}' با موفقیت انجام شد.",
            is_read=False,
            activity_details=activity  # تنظیم فیلد activity_details

        )

        # افزودن تمامی کاربران فرماندهی به نوتیفیکیشن
        for commander in commander_persons:
            notification.user.add(commander.user)
        
        notification.save()  # ذخیره نهایی

    return redirect(f'/meeting/duties/{activity.mainTask.id}/activities')

def notifications_view(request):
    person_instance = request.user.person  # فرض بر این است که هر کاربر یک Person دارد
    notifications = Notification.objects.filter(user=request.user, is_read=False, has_evaluated=False)
    futureworks = Futurework.objects.filter(persons=person_instance, is_done=False)  # فقط کارهای خوانده نشده
    return render(request, 'activity/notifications.html', {'notifications': notifications, 'futureworks': futureworks})

def history_dashboard(request):
    notifications = Notification.objects.select_related('activity_details').order_by('-created_at')
    futureworks = Futurework.objects.select_related('title', 'Council').order_by('-created_at')

    context = {
        'notifications': notifications,
        'futureworks': futureworks,
    }
    return render(request, 'activity/history.html', context)

def mark_futurework_read(request, futurework_id):
    try:
        futurework = Futurework.objects.get(id=futurework_id)
        futurework.is_read = True
        futurework.save()
    except Futurework.DoesNotExist:
        pass  # در صورت عدم وجود کار آینده، خطا رخ ندهد
    return redirect('notifications')  # بازگشت به صفحه نوتیفیکیشن‌ها

def activity_not_done(request, pk):
    activity = get_object_or_404(ActivityDetails, pk=pk)
    if request.method == 'POST':
        description = request.POST.get('description', '')
        activity.done = False
        activity.description = description
        activity.time = None  # پاک کردن زمان در صورت انجام‌نشده
        activity.save()
        messages.success(request, 'وضعیت فعالیت به انجام‌نشده تغییر یافت.')
    return redirect(f'/meeting/duties/{activity.mainTask.id}/activities/')

def duties_by_categories_list(request):
    categories = DutiesOfUnits.RASTE_CHOICES
    return render(request, 'activity/duties_by_categories_list.html', {'categories': categories})

# ویو برای نمایش وظایف اصلی و ریزفعالیت‌ها بر اساس رسته
def duties_and_activities_by_category(request, category):
    duties = DutiesOfUnits.objects.filter(raste_categories=category)
    return render(request, 'activity/duties_and_activities_by_category.html', {
        'duties': duties,
        'category': category,
    })

def duties_of_units_create(request):
    category = request.GET.get('category', None)
    if request.method == 'POST':
        form = DutiesOfUnitsForm(request.POST)
        if form.is_valid():
            form.save()
            return redirect('duties_and_activities_by_category', category=form.cleaned_data['raste_categories'])
    else:
        form = DutiesOfUnitsForm(initial={'raste_categories': category})
    return render(request, 'activity/duties_of_units_form.html', {'form': form})

from django.utils import timezone
from django.shortcuts import get_object_or_404, redirect, render
from django.contrib import messages
from .models import Notification, Evaluation

def submit_evaluation(request, notification_id):
    # بازیابی پیامک
    notification = get_object_or_404(Notification, id=notification_id)

    # بررسی اینکه آیا پیامک به ریزفعالیت مرتبط است
    if not notification.activity_details:
        messages.error(request, 'این پیامک به ریزفعالیتی مرتبط نیست.')
        return redirect('notifications')

    # استخراج وظیفه اصلی و رسته مرتبط
    activity_detail = notification.activity_details
    main_task = activity_detail.mainTask
    raste_category = main_task.raste_categories

    if request.method == 'POST':
        value_choice = request.POST.get('value_choice')
        description = request.POST.get('description', '')

        # بررسی صحت فیلدهای ارسالی
        if not value_choice:
            messages.error(request, 'لطفاً نظر خود را وارد کنید.')
            return redirect('notifications')

        # یافتن یا ایجاد رکورد جدید
        evaluation, created = Evaluation.objects.update_or_create(
            mainTask=activity_detail,  # شناسه اصلی برای یافتن رکورد
            defaults={
                "raste_categories": main_task,
                "value_choices": value_choice,
                "description": description,
                "time": timezone.now(),
            }
        )

        # بروزرسانی وضعیت نوتیفیکیشن
        notification.has_evaluated = True
        notification.save()

        messages.success(request, 'نظر شما با موفقیت {} شد.'.format("ثبت" if created else "به‌روزرسانی"))
        return redirect('notifications')

    return render(
        request,
        'activity/submit_evaluation.html',
        {
            'notification': notification,
            'activity_detail': activity_detail,
            'main_task': main_task,
            'raste_category': raste_category,
        }
    )



from django.shortcuts import get_object_or_404
from django.contrib.auth.mixins import LoginRequiredMixin
from django.views.generic import ListView
from .models import ActivityDetails, DutiesOfUnits, Person

class MyDutiesView(LoginRequiredMixin, ListView):
    model = ActivityDetails
    template_name = 'activity/my_duties.html'
    context_object_name = 'activity_details'

    # دیکشنری نگاشت بین مقادیر فارسی و کلیدهای انگلیسی
    RASTE_MAPPING = {
        'ورزشی و اردویی': 'vazesh_va_ordoyi',
        'هییت': 'heiat',
        'مالی': 'mali',
        'فرهنگی': 'farhangi',
        'علمی و آموزشی': 'elmi_va_amoshghari',
        'حفا': 'hafa',
        'تعلیم و تربیت': 'taleem_va_tarbiyat',
        'اداری': 'edari',
        'اجتماعی': 'ejtemai',
        'عملیات': 'omaliat',
    }

    def get_queryset(self):
        # دریافت شخص مرتبط با کاربر جاری
        person = get_object_or_404(Person, user=self.request.user)
        cultural_info = getattr(person, 'person_cultural', None)

        # اگر اطلاعات فرهنگی موجود نبود، لیست خالی برگردان
        if not cultural_info:
            return ActivityDetails.objects.none()

        # دریافت رسته شخص و تطبیق آن با کلید انگلیسی
        raste_farsi = cultural_info.raste_categories
        raste_english = self.RASTE_MAPPING.get(raste_farsi)

        # اگر کلید انگلیسی پیدا نشد، لیست خالی برگردان
        if not raste_english:
            return ActivityDetails.objects.none()

        # فیلتر کردن وظایف و ریزفعالیت‌ها
        duties = DutiesOfUnits.objects.filter(raste_categories=raste_english)
        activity_details = ActivityDetails.objects.filter(mainTask__in=duties)

        # استخراج وظایف اصلی منحصر به فرد
        unique_main_tasks = set(activity_details.values_list('mainTask', flat=True))

        # گرفتن اولین ریزفعالیت برای هر وظیفه اصلی
        filtered_details = [
            activity_details.filter(mainTask=task).first() for task in unique_main_tasks
        ]

        return filtered_details

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        person = self.request.user.person
        cultural_info = getattr(person, 'person_cultural', None)

        # اضافه کردن رسته به context
        context['raste'] = cultural_info.raste_categories if cultural_info else None
        return context

class SameRasteUsersView(LoginRequiredMixin, ListView):
    model = User
    template_name = 'activity/same_raste_users.html'
    context_object_name = 'same_raste_users'

    def get_queryset(self):
        person = get_object_or_404(Person, user=self.request.user)
        cultural_info = getattr(person, 'person_cultural', None)

        if not cultural_info:
            return User.objects.none()

        raste = cultural_info.raste_categories
        users_with_same_raste = User.objects.filter(person__person_cultural__raste_categories=raste).exclude(id=self.request.user.id)

        return users_with_same_raste

    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        person = self.request.user.person
        cultural_info = getattr(person, 'person_cultural', None)

        # اضافه کردن اطلاعات رسته به context
        if cultural_info:
            context['raste'] = cultural_info.raste_categories
            context['sardoshi'] = cultural_info.sardoshi_categories  # اضافه کردن سردوشی به context
        else:
            context['raste'] = None
            context['sardoshi'] = None

        # افزودن اطلاعات تماس و آدرس به context برای هر کاربر
        same_raste_users = context.get('same_raste_users', [])
        users_data = []
        for user in same_raste_users:
            private_info = PersonPrivateInfo.objects.filter(person=user.person).first()  # دریافت اطلاعات شخصی کاربر
            user_phone = private_info.phone if private_info and private_info.phone else 'شماره موبایل موجود نیست'
            user_address = user.person.person_address.first()

            # استخراج اطلاعات تماس و آدرس
            contact_info = {
                'phone': user_phone,
                'address': user_address.address if user_address else 'آدرس موجود نیست',
                'sardoshi': cultural_info.sardoshi_categories if cultural_info else 'سردوشی موجود نیست',  # افزودن سردوشی
            }

            users_data.append({
                'user': user,
                'contact_info': contact_info,
            })

        context['users_data'] = users_data
        return context

@login_required
def evaluations_view(request):
    try:
        # یافتن مسئول واحد بر اساس کاربر
        council_member = CouncilMembers.objects.get(person=request.user.person)
        # نظرات مربوط به واحد مسئول
        evaluations = Evaluation.objects.filter(raste_categories=council_member.raste_categories)
    except CouncilMembers.DoesNotExist:
        # اگر کاربر مسئول واحد نباشد، نظراتی نمایش داده نمی‌شود
        evaluations = []

    return render(request, 'council/evaluations_page.html', {'evaluations': evaluations})





def reportcard_unit(request):
    
    categories = DutiesOfUnits.RASTE_CHOICES
    return render(request, 'activity/reportcard_unit_list.html', {'categories': categories})

from django.db.models import Max, F

def reportcard_unit_by_category(request, category):
    duties = DutiesOfUnits.objects.filter(raste_categories=category)
    
    # فیلتر کردن ریز فعالیت‌ها که is_reset=False هستند
    activity_details = ActivityDetails.objects.filter(mainTask__raste_categories=category, is_reset=False)

    # دریافت نمرات و جایگذاری مقدار 0 در صورت نبود نمره
    evaluations = Evaluation.objects.filter(mainTask__in=activity_details)
    # evaluations = Evaluation.objects.filter(mainTask__in=activity_details).values('mainTask').annotate(last_time=Max('time'))
   
    total_score = evaluations.aggregate(
        total=Coalesce(Sum(F("value_choices") * F("mainTask__ratio"), output_field=FloatField()), Value(0.0))
    )["total"]

    total_ratio = activity_details.aggregate(
        total=Coalesce(Sum(F("ratio"), output_field=FloatField()), Value(1.0))
    )["total"]

    # محاسبه معدل کل
    avg_score = total_score / total_ratio if total_ratio > 0 else 0.0
    category_fa = dict(DutiesOfUnits.RASTE_CHOICES).get(category, "نامشخص")

    return render(request, 'activity/reportcard_unit_by_category.html', {
        'duties': duties,
        'activity_details': activity_details,
        'category': category_fa,
        'avg_score': round(avg_score, 2),  # گرد کردن معدل به 2 رقم اعشار
    })


import threading
from django.shortcuts import redirect
from .models import ActivityDetails
from django.http import HttpResponseBadRequest
def reset_activity_details(request):
    if request.method == 'POST':
        # مقدار is_reset را True تنظیم کن
        ActivityDetails.objects.update(is_reset=True, done=False ,description = "-" , 
        time = None )
       
        Evaluation.objects.update(value_choices = None)
        # تابع برای بازگرداندن مقدار به False
        def revert_reset_flag():
            ActivityDetails.objects.update(is_reset=False)
            
              # اولین رکورد را به‌عنوان نمونه می‌گیریم
            
        # بعد از ۵ ثانیه مقدار is_reset دوباره False می‌شود
        threading.Timer(5.0, revert_reset_flag).start()

        return redirect('reportcard_unit')
 
    return HttpResponseBadRequest("خطای 400: فقط درخواست‌های POST مجاز هستند.")

from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required
from django.db.models import Sum, F, FloatField, Value
from django.db.models.functions import Coalesce
from .models import DutiesOfUnits, ActivityDetails, Evaluation
from persons.models import PersonCultural

@login_required
def reportcard_unit_history(request):
    person = get_object_or_404(Person, user=request.user)

    person_cultural = get_object_or_404(PersonCultural, person=person)
    raste_value = person_cultural.raste_categories
    
    raste_dict = dict(DutiesOfUnits.RASTE_CHOICES)
    category_key = next((key for key, value in raste_dict.items() if value == raste_value), None)
    
    if category_key:
        return redirect('reportcard_unit_by_category_history', category=category_key)
    
    return render(request, 'activity/reportcard_unit_list_history.html', {'categories': DutiesOfUnits.RASTE_CHOICES})

@login_required
def reportcard_unit_by_category_history(request, category):
    raste_dict = dict(DutiesOfUnits.RASTE_CHOICES)
    category_fa = raste_dict.get(category, "نامشخص")
    
    duties = DutiesOfUnits.objects.filter(raste_categories=category)
    activity_details = ActivityDetails.objects.filter(mainTask__raste_categories=category, is_reset=False)
    
    evaluations = Evaluation.objects.filter(mainTask__in=activity_details)
    total_score = evaluations.aggregate(
        total=Coalesce(Sum(F("value_choices") * F("mainTask__ratio"), output_field=FloatField()), Value(0.0))
    )["total"]

    total_ratio = activity_details.aggregate(
        total=Coalesce(Sum(F("ratio"), output_field=FloatField()), Value(1.0))
    )["total"]

    avg_score = total_score / total_ratio if total_ratio > 0 else 0.0
    
    return render(request, 'activity/reportcard_unit_by_category.html', {
        'duties': duties,
        'activity_details': activity_details,
        'category': category_fa,
        'avg_score': round(avg_score, 2),
    })
