from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import  *
from persons.models import  *

@receiver(post_save, sender=CouncilMembers)
def add_council_member_role(sender, instance, created, **kwargs):
    if created:  # فقط وقتی رکورد جدید ایجاد شد
        try:
            council_role = Role.objects.get(name='اعضای_شورا')  # گرفتن نقش از دیتابیس
            instance.person.role.add(council_role)  # اضافه کردن نقش به شخص
        except Role.DoesNotExist:
            pass  # اگر نقش وجود نداشت، خطایی رخ ندهد



@receiver(post_save, sender=CouncilMembers)
def update_person_cultural_raste(sender, instance, created, **kwargs):
    if created:  # فقط وقتی رکورد جدید ایجاد شد
        person_cultural, _ = PersonCultural.objects.get_or_create(person=instance.person)
        person_cultural.raste_categories = instance.raste_categories  # تنظیم مقدار رسته
        person_cultural.save()
