from django.db import models
from persons.models import Person
from django.utils import timezone
from django_jalali.db import models as jmodels
from persons.models import Person
import jdatetime
from ckeditor.fields import RichTextField

# تبدیل تاریخ میلادی به شمسی


class Council (models.Model):
    name = models.CharField(max_length=250, verbose_name='نام جلسه')
    persons = models.ManyToManyField(
        Person, verbose_name='افراد حاظر در جلسه', null=True, blank=True)
    meeting_place = models.CharField(
        max_length=150, verbose_name='مکان جلسه', null=True, blank=True)
    date_run = jmodels.jDateField(verbose_name='تاریخ جلسه',null=True,blank=True)
    description = RichTextField(max_length=999,
        null=True, blank=True, verbose_name='توضیحات')
    date_miladi = timezone.now()
    date_jalali = jdatetime.datetime.fromgregorian(datetime=date_miladi)


    class Meta:
        verbose_name = 'جلسه شورا'
        verbose_name_plural = 'جلسات شورا'
 
    def __str__(self):
        return f"{self.name}در{self.meeting_place}"


class CouncilApprovals(models.Model):
    council = models.ForeignKey(Council, on_delete=models.CASCADE,
                                verbose_name="شورا", related_name="CouncilApprovals")
    title = models.CharField(max_length=350, verbose_name='عنوان مصوبه')
    file = models.FileField(upload_to='CouncilApprovals',
                            verbose_name='فایل جلسه', null=True, blank=True)
    state = models.BooleanField(
        default=False, verbose_name='تصویب شده؟')
    positive_pole = models.IntegerField(
        null=True, blank=True, verbose_name='آرای مثبت')
    negativ_pole = models.IntegerField(
        null=True, blank=True, verbose_name='آرای منفی')
    bstentions_pole = models.IntegerField(
        null=True, blank=True, verbose_name='آرای ممتنع')

    class Meta:
        verbose_name = 'مصوبه‌جلسه'
        verbose_name_plural = 'مصوبات‌جلسه'

    def __str__(self):
        return self.title


class CouncilMembers(models.Model):
    RASTE_CHOICES = (
        ('ورزشی و اردویی', 'ورزشی و اردویی'),
        ('هییت', 'هییت'),
        ('مالی', 'مالی'),
        ('فرهنگی', 'فرهنگی'),
        ('علمی و آموزشی', 'علمی و آموزشی'),
        ('حفا', 'حفا'),
        ('تعلیم و تربیت', 'تعلیم و تربیت'),
        ('اداری', 'اداری'),
        ( 'اجتماعی', 'اجتماعی'),
        ('عملیات', 'عملیات'),
        ('اداری', 'اداری'),
        ('اطلاعات','اطلاعات'),
    )
    person =models.ForeignKey(Person,verbose_name='فرد',on_delete=models.CASCADE)
    raste_categories =models.CharField(max_length=20,
                                        verbose_name='رسته',
                                        choices=RASTE_CHOICES,null=True,blank=True)
    
    class Meta:
        verbose_name = 'عضو شورا'
        verbose_name_plural = 'اعضا شورا'

    def __str__(self):
        return f"{self.person}مسئول رسته {self.raste_categories}"

    



class Futurework(models.Model):
    STATUS_CHOICES = [
        ("not done", "انجام نشده"),
        ("in progress", "درحال انجام"),
        ("done", "انجام شده"),
    ]
    Council = models.ForeignKey(
        Council, on_delete=models.CASCADE, verbose_name="شورا", related_name="Futurework")
    persons = models.ManyToManyField(
        Person, verbose_name='افراد  انجام دهنده', null=True, blank=True)
    title = models.ForeignKey(CouncilApprovals,on_delete=models.CASCADE, verbose_name="عنوان")
    status = models.CharField(choices=STATUS_CHOICES,
                              max_length=25, verbose_name="وضعیت")
    created_at = models.DateTimeField(auto_now_add=True)

    description = models.CharField(
        max_length=255, verbose_name="توضیحات", null=True, blank=True)

    is_read = models.BooleanField(default=False, verbose_name="خوانده شده")
    is_done = models.BooleanField(default=False, verbose_name="انجام شده")  
    
    def created_at_shamsi(self):
        return jdatetime.date.fromgregorian(date=self.created_at).strftime('%Y/%m/%d')



    class Meta:
        verbose_name = 'کار آینده'
        verbose_name_plural = 'کار های آینده'
          

class DutiesOfUnits(models.Model):
    RASTE_CHOICES = (
    ('vazesh_va_ordoyi', 'ورزشی و اردویی'),
    ('heiat', 'هییت'),
    ('mali', 'مالی'),
    ('farhangi', 'فرهنگی'),
    ('elmi_va_amoshghari', 'علمی و آموزشی'),
    ('hafa', 'حفا'),
    ('taleem_va_tarbiyat', 'تعلیم و تربیت'),
    ('edari', 'اداری'),
    ('ejtemai', 'اجتماعی'),
    ('omaliat', 'عملیات'),
    ('etelaat' , "اطلاعات"),
)

    raste_categories = models.CharField(
        max_length=20,
        verbose_name='رسته',
        choices=RASTE_CHOICES,
    )
    mainTask = models.CharField(
        max_length=250,
        null=True,
        blank=True,
        verbose_name="وظایف اصلی"
    )

    class Meta:
        verbose_name = "وظیفه واحد"
        verbose_name_plural = 'وظایف واحد'

    def __str__(self):
        return f"{self.raste_categories} "

 
class ActivityDetails(models.Model):
    mainTask = models.ForeignKey(
        DutiesOfUnits, on_delete=models.CASCADE, verbose_name="وظایف اصلی"
    )
    microActivity = models.CharField(
        max_length=250, null=True, blank=True, verbose_name="ریزفعالیت"
    )
    ratio = models.IntegerField(
        null=False, blank=False, default=1, verbose_name="ضریب"
    )
    done = models.BooleanField(
        default=False, verbose_name="انجام شده؟"
    )
    description = models.CharField( max_length=500 , 
        null=False, blank=True, verbose_name="توضیحات"
    )
    time = jmodels.jDateField( verbose_name="تاریخ",null=True,blank=True)
    is_reset = models.BooleanField(default=False, verbose_name="ریست شده؟")


    class Meta:
        verbose_name = "ریزفعالیت"
        verbose_name_plural = 'ریزفعالیت‌ها'

    def __str__(self):
        return f"{self.microActivity}"


class Evaluation(models.Model):
    VALUE_CHOICES = ( (0.0, "غیرقابل قبول") , 
                        (0.25 , "ضعیف"),
                        (0.5 , "متوسط"),
                        (0.75 , "خوب"),
                        (1.0 , "عالی")
     )
    raste_categories = models.ForeignKey(DutiesOfUnits, on_delete=models.CASCADE,
        max_length=20,
        verbose_name='رسته',
        
    )
    mainTask = models.ForeignKey(
        ActivityDetails, on_delete=models.CASCADE, verbose_name="وظایف اصلی")
    value_choices = models.FloatField(
        max_length=55,
        choices=VALUE_CHOICES,
        verbose_name='نظر',null=True,  # اجازه می‌دهد مقدار None ذخیره شود
        blank=True,
    )
    time = models.DateField(
        null=False, blank=True, default=timezone.now, verbose_name="تاریخ"
    )
    description = models.CharField(max_length= 500,
        null=False, blank=True, verbose_name="توضیحات"
    )

    class Meta:
        verbose_name = "نظر"
        verbose_name_plural = 'نظرها'

    def __str__(self):
        return f"{self.raste_categories}-{self.mainTask}"






from django.db import models
from django.contrib.auth.models import User
import jdatetime

class Notification(models.Model):
    user = models.ManyToManyField(User)
    title = models.CharField(max_length=255)
    message = models.TextField()
    is_read = models.BooleanField(default=False)
    created_at = models.DateTimeField(auto_now_add=True)
    activity_details = models.ForeignKey(
        'ActivityDetails', on_delete=models.CASCADE, null=True, blank=True, verbose_name='ریزفعالیت'
    )
    has_evaluated = models.BooleanField(default=False)

    def created_at_shamsi(self):
        return jdatetime.date.fromgregorian(date=self.created_at).strftime('%Y/%m/%d')

    def __str__(self):
        return self.title


