from django.urls import path
from . import views
from .views import*

urlpatterns = [
    path('posts/', views.PostListView.as_view(), name='post-list'),
    path('post/<int:pk>/', views.PostDetailView.as_view(), name='post-detail'),
    path('post/create/', views.create_post, name='create-post'),
    path('post/edit/<int:pk>/', edit_post, name='edit-post'),
    path('post/delete/<int:pk>/', delete_post, name='delete-post'),
    path('categories/', views.CategoryListView.as_view(), name='category-list'),
    path('category/create/ajax/', views.create_category_ajax, name='create-category-ajax'),
    path('like/<int:post_id>/', views.like_post, name='like-post'),
    path('increment-visit/<int:post_id>/', views.increment_visit, name='increment_visit'),
    path('category/delete/<int:category_id>/', views.delete_category, name='delete-category'),
    path("category-management/", views.category_management, name="category_management"),
    path("search_persons", search_persons, name="search_persons"),
    

]
