from django.db import models
from django.utils import timezone
from persons.models import Person
from ckeditor.fields import RichTextField
import jdatetime
from django_jalali.db import models as jmodels

class Category(models.Model):
    title = models.CharField(max_length=100, verbose_name='عنوان')
    parent = models.ForeignKey(
        "self", on_delete=models.CASCADE, blank=True, null=True)

    class Meta:
        verbose_name = "دسته بندی"
        verbose_name_plural = "دسته بندی ها"

    def __str__(self):
        return self.title

class Post(models.Model):
    author = models.ForeignKey(
        Person, on_delete=models.CASCADE, verbose_name='نویسنده')
    category = models.ForeignKey(
        Category, on_delete=models.SET_NULL, null=True, blank=True, verbose_name='دسته بندی')
    title = models.CharField(max_length=100, verbose_name='عنوان')
    content = RichTextField(verbose_name='محتوا', null=True, blank=True)
    poster = models.ImageField(
        verbose_name='پوستر', upload_to="poster", null=True, blank=True)
    thumbnail = models.ImageField(
        verbose_name='تامنیل', upload_to="thumbnail", null=True, blank=True)
    published_date = jmodels.jDateField(
         verbose_name='تایم انتشار', blank=True, null=True, default=jdatetime.datetime.now)
    like_count = models.PositiveIntegerField(default=0, verbose_name="تعداد لایک")
    view_count = models.PositiveIntegerField(default=0)  # فیلد جدید برای تعداد بازدیدها


   
    class Meta:
        verbose_name = "مقاله"
        verbose_name_plural = "مقاله ها"

    def __str__(self):
        return self.title

class Comment(models.Model):
    response = models.ForeignKey(
        "self", on_delete=models.CASCADE, blank=True, null=True, verbose_name="پاسخ کامنت")
    post = models.ForeignKey(
        Post, related_name='comments', on_delete=models.CASCADE)
    author = models.CharField(max_length=100, verbose_name='نویسنده')
    content = RichTextField(verbose_name='محتوا', null=True, blank=True)
    published_date = jmodels.jDateField(
         verbose_name='تایم انتشار')

    class Meta:
        verbose_name = "کامنت"
        verbose_name_plural = "کامنت ها"

    def __str__(self):
        return f'Comment by {self.author}'
