"""
Django settings for basigansar project.

Generated by 'django-admin startproject' using Django 5.0.7.

For more information on this file, see
https://docs.djangoproject.com/en/5.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.0/ref/settings/
"""

import os
import locale
from pathlib import Path

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-_rh2d-_7ypwedim=h3z$4$6^5gd$acfl1$nhma^xeyn82vqj$7'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True
DJANGO_CRON_DELETE_LOGS = True  # حذف لاگ‌ها بعد از اجرا
DJANGO_CRON_LOGGING = False  # غیرفعال کردن لاگ‌گیری

ALLOWED_HOSTS = ['*']

CRONJOBS = [
    ('* * * * *', 'persons.cron.create_random_report_card'),  # اجرای هر دقیقه
]

CRON_CLASSES = [
    'persons.cron.CreateReportCardCronJob',  # استفاده از اپلیکیشن persons
]



# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django_cron',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'ckeditor',
    'ckeditor_uploader',  # در صورت نیاز به آپلود
    'persons',
    'meetings',
    'rest_framework',
    'widget_tweaks',
    'blog',
    'django_select2',
    'django_jalali',
    'jalali_date',
    
    






]
# settings.py

DJANGO_CRON_LOG_LEVEL = 'CRITICAL'  # فقط خطاهای بحرانی ذخیره می‌شوند
DJANGO_CRON_DELETE_LOGS_OLDER_THAN = 0  # لاگ‌ها ذخیره نمی‌شوند
DJANGO_CRON_SAVE_SUCCESSFUL_JOBS = False  # از ذخیره موفقیت‌ها جلوگیری می‌کند
DJANGO_CRON_DISABLE_LOGGING = True

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'null': {
            'class': 'logging.NullHandler',
        },
    },
    'loggers': {
        'django_cron': {
            'handlers': ['null'],
            'level': 'CRITICAL',  # فقط خطاهای بحرانی ثبت می‌شوند
            'propagate': False,
        },
    },
}


STATIC_URL = '/static/'  # آدرس عمومی برای دسترسی به فایل‌های استاتیک

STATICFILES_DIRS = [
    BASE_DIR / "static",  # فایل‌های استاتیک پروژه در این مسیر قرار می‌گیرند
]

STATIC_ROOT = BASE_DIR / "staticfiles"  # محل جمع‌آوری فایل‌های استاتیک


REST_FRAMEWORK = {
    'DEFAULT_FILTER_BACKENDS': ['django_filters.rest_framework.DjangoFilterBackend']
}

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'basigansar.urls'
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [BASE_DIR / 'Templates'],  # مسیر قالب‌ها
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',  # این خط مهم است
                'django.contrib.messages.context_processors.messages',
                'persons.context_processors.user_roles',

            ],
        },
    },
]

WSGI_APPLICATION = 'basigansar.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.0/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    }
}







# Password validation
# https://docs.djangoproject.com/en/5.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.0/topics/i18n/

LANGUAGE_CODE = 'fa-ir'  # زبان فارسی
TIME_ZONE = 'Asia/Tehran'  # منطقه زمانی تهران


locale.setlocale(locale.LC_ALL)



USE_I18N = True  # فعال‌سازی بین‌المللی‌سازی (i18n)
USE_L10N = True  # فعال‌سازی محلی‌سازی (l10n)
USE_TZ = True  # فعال‌سازی منطقه زمانی

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.0/howto/static-files/


# Default primary key field type
# https://docs.djangoproject.com/en/5.0/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

MEDIA_ROOT = BASE_DIR / 'media'
# مسیر ذخیره‌سازی فایل‌های رسانه‌ای
MEDIA_URL = '/media/'  # URL برای دسترسی به تصاویر
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')
CKEDITOR_UPLOAD_PATH = "uploads/"
MEDIA_URL = '/media/'



SESSION_ENGINE = "django.contrib.sessions.backends.cache"
SESSION_CACHE_ALIAS = "default"

SESSION_COOKIE_SECURE = False  # اگر روی True باشد، فقط در HTTPS کار می‌کند
SESSION_COOKIE_HTTPONLY = True  # از جاوا اسکریپت محافظت می‌کند، اما مشکلی ایجاد نمی‌کند
SESSION_COOKIE_SAMESITE = "Lax"  # یا "None" برای دامنه‌های دیگر

# مدت زمان اعتبار سشن در ثانیه (۳۰ روز)
SESSION_COOKIE_AGE = 60 * 60 * 24 * 30  # 30 روز

# مشخص می‌کند که آیا سشن پس از بسته شدن مرورگر حذف شود یا نه
SESSION_EXPIRE_AT_BROWSER_CLOSE = False

# فعال کردن سشن در دیتابیس (اختیاری)
SESSION_ENGINE = "django.contrib.sessions.backends.db"
