from django.urls import path
from .views import *
from django.contrib.auth.views import LogoutView
from . import views
from django.conf.urls import handler404
from django.conf import settings
from django.conf.urls.static import static


handler404 = 'persons.views.custom_404_view'
 
urlpatterns = [
    path('', custom_login_view, name='custom_login_view'),
    
    path('dashboard/', profile_view, name='dashboard'),
    path('logout/', logout_view, name='logout'),
    path('information/', profile_viewInfo, name='information'),
    path('personaddress/', profile_viewaAddress, name='personaddress'),
    path('other/', profile_viewOther, name='other'),
    path('update/<int:person_id>/', profile_update_view, name='update'),
    path('update2/<int:person_id>/', profile_update2_view, name='update2'),

    path('users/', user_list_view, name='user_list'),
    path('download_excel/', download_excel, name='download_excel'),
    path('profile_view/<int:person_id>', profile_viewuser, name='view'),
    path('delete/<int:person_id>', delete_user, name='delete'),
    path('add_user/' , add_user , name='add'), 
    path('rings/', RingListView.as_view(), name='ring_list'),
    path('rings/create/', RingCreateView.as_view(), name='ring_create'),
    path('rings/createe/', RingCreateeView.as_view(), name='ring_createe'),
    path('rings/<int:pk>/edit/', RingUpdateView.as_view(), name='ring_update'),
    path('rings/<int:pk>/delete/', RingDeleteView.as_view(), name='ring_delete'),
    path('ring-members/', RingMemberListView.as_view(), name='ring_member_list'),
    path('ring-members/create/', RingMemberCreateView.as_view(), name='ring_member_create'),
    path('ring-members/createe/', RingMemberCreateeView.as_view(), name='ring_member_createe'),
    path('ring-members/<int:pk>/edit/', RingMemberUpdateView.as_view(), name='ring_member_update'),
    path('ring-members/<int:pk>/delete/', RingMemberDeleteView.as_view(), name='ring_member_delete'),
    path('rings-with-members/', RingWithMembersListView.as_view(), name='rings_with_members'),
    path('ring/<int:ring_pk>/edit/', edit_ring_members, name='edit_ring_members'),
    path('ring/<int:ring_pk>/add/', views.add_member_to_ring, name='add_member_to_ring'),
    path('search_persons/', search_persons, name='search_p'),
    path('search_p/', search_p, name='search_pp'),

    #
    
    path('report/', views.user_dashboard, name='user_dashboard'),
    path('member/<int:member_id>/reports/', views.member_report_cards, name='member_report_cards'),
    path('report/<int:report_card_id>/details/', views.report_card_details, name='report_card_details'),
    path('create_report_card_detail/<int:report_card_id>/', views.create_report_card_detail, name='create_report_card_detail'),
 
    #
   
    path('reportcard_list/', ReportCardListView.as_view(), name='reportcard_list'),
    path("rate/", views.roles_list, name="roles_rate"),
    path("rate-users/", views.roles_list_view, name="roles_list"),
    path("rate-users/<str:role_key>/", views.rate_users_view, name="rate_users"),
    path('reportcard_detail/', usersreportcard_detail, name='reportcard_detail'),
    # path('update-scores/', views.update_user_scores, name='update_user_scores'),
    path('edit-scores/<int:person_id>/<str:role_key>/', views.edit_user_scores, name='edit_scores'),

    path('reportcard/<int:reportcard_id>/',ReportCardDetailView , name='reportcard_detail'),
    path('reportcard/create/', ReportCardCreateView.as_view(), name='reportcard_create'),
    path('reportcard/<int:pk>/update/', ReportCardUpdateView.as_view(), name='reportcard_update'),
    path('reportcard/<int:pk>/delete/', ReportCardDeleteView.as_view(), name='reportcard_delete'),
    path('reportcard/<int:pk>/add-detail/', ReportCardDetailCreateView.as_view(), name='reportcard_add_detail'),
    path("update-detail-scores/", update_all_detail_scores, name="update_detail_scores"),
    path('reportcard/<int:pk>/delete-detail/', ReportCardDetailDeleteView.as_view(), name='reportcard_delete_detail'),
    path('index/add/', add_index, name='add_index'),
    path('index/list/', index_list, name='index_list'),
    path('index/update/<int:pk>/', update_index, name='index_update'),
    path('index/delete/<int:pk>/', delete_index, name='index_delete'),
    path('verify-identity/', verify_identity_view, name='verify_identity'),
    path('reset-password/', reset_password_view, name='reset_password'),
    path('password-change/', password_change_view, name='password_change'),
    path('my-ring/', RingMembersView.as_view(), name='ring_members'), 
            path("export_members/", export_selected_members, name="export_selected_members"),

    path('member/<int:pk>/', MemberDetailView.as_view(), name='member_detail'),
    path('children/', views.child_list, name='child_list'),
    path('family', FamilyListView.as_view(), name='family_list'),
    path('family/create/', FamilyCreateView.as_view(), name='family_create'),
    path('family/<int:pk>/edit/', FamilyUpdateView.as_view(), name='family_update'),
    path('family/<int:pk>/delete/', FamilyDeleteView.as_view(), name='family_delete'),
    path('users_report/', views.user_list_report, name='user_list_report'),
    path('users_report/<int:person_id>/report-cards/', views.user_report_cards, name='user_report_cards'),
    path('users_report/<int:person_id>/report-card/', views.report_card_finaly, name='report_card_finaly'),
    path('upgrade-sardoshi/<int:person_id>/', views.upgrade_sardoshi, name='upgrade_sardoshi'),
    path('get_user_avatar/', views.get_user_avatar, name='get_user_avatar'), 
     path('upload_pic/<int:person_id>/', upload_pic, name='upload_pic'),
     path('psychological-test/<int:person_id>/', views.psychological_test_view, name='psychological_test'),
     path('show-reportcard-my-child/', views.show_report, name='show_reportcard_my_child'),
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
