from datetime import timedelta
import random
from django.utils.timezone import now
from django_cron import CronJobBase, Schedule
from django.apps import apps

def get_model(name):
    return apps.get_model('persons', name)

class CreateReportCardCronJob(CronJobBase):
    RUN_EVERY_MINS = 1  # اجرای هر دقیقه برای تست سریع
    ALLOW_PARALLEL_RUNS = False

    schedule = Schedule(run_every_mins=RUN_EVERY_MINS)
    code = 'persons.create_report_card_cron'
    do_not_log = True  # ✅ این خط ذخیره لاگ در مدل رو غیرفعال می‌کنه


    def do(self):
        try:
            Person = get_model('Person')
            RingMember = get_model('RingMember')
            DateHalfyear = get_model('DateHalfyear')
            ReportCard = get_model('ReportCard')
            ReportCardFinaly = get_model('ReportCardFinaly')

            def get_or_create_datehalfyear(title, duration_minutes):
                date_obj = DateHalfyear.objects.filter(title=title).order_by('-start_date').first()
                if not date_obj or date_obj.end_date <= now():
                    date_obj = DateHalfyear.objects.create(
                        title=title,
                        start_date=now(),
                        end_date=now() + timedelta(minutes=duration_minutes)
                    )
                return date_obj

            cultural_duration = 2 * 24 * 60  # مدت زمان فرهنگی: ۲ روز
            stemmer_duration = 7 * 24 * 60   # مدت زمان مستمر: ۷ روز
            final_duration = 14 * 24 * 60    # مدت زمان نهایی: ۱۴ روز

            # ✅ ساخت کارنامه فرهنگی به صورت مداوم
            date_cultural = get_or_create_datehalfyear("فرهنگی", cultural_duration)
            for person in Person.objects.all():
                if person.role.filter(name__in=['فرماندهی', 'ادمین_اصلی', 'جانشین', 'خانواده']).exists():
                    continue

                ring_member = RingMember.objects.filter(person=person).first()
                ring = ring_member.ring if ring_member else None

                if not ReportCard.objects.filter(person=person, date=date_cultural, title="فرهنگی").exists():
                    ReportCard.objects.create(
                        person=person,
                        date=date_cultural,
                        title="فرهنگی",
                        average_score=round(random.uniform(10, 20), 2),
                        ring=ring
                    )

            # 🔄 چرخه مستمر و نهایی پشت سر هم
            for person in Person.objects.all():
                if person.role.filter(name__in=['فرماندهی', 'ادمین_اصلی', 'جانشین', 'خانواده']).exists():
                    continue

                ring_member = RingMember.objects.filter(person=person).first()
                ring = ring_member.ring if ring_member else None

                last_stemmer = ReportCard.objects.filter(person=person, title="مستمر").order_by('-date__start_date').first()
                last_final = ReportCard.objects.filter(person=person, title="نهایی").order_by('-date__start_date').first()

                # 🚀 حالت اول: اگر هیچ مستمر و نهایی وجود نداشته باشد → مستمر بساز
                if not last_stemmer and not last_final:
                    date_stemmer = get_or_create_datehalfyear("مستمر", stemmer_duration)
                    report_card_stemmer = ReportCard.objects.create(
                        person=person,
                        date=date_stemmer,
                        title="مستمر",
                        average_score=round(random.uniform(10, 20), 2),
                        ring=ring
                    )
                    ReportCardFinaly.objects.create(
                        person=person,
                        title=report_card_stemmer,
                        sargroh=None,
                        talimvatarbiat=None,
                        elmivaamozeshi=None,
                        varzeshivaordoee=None,
                        syasatgozari=None,
                        farmandehi=None,
                        emamjamaat=None,
                        upgrade_used=False
                    )


                # 🚀 حالت دوم: اگر مستمر تمام شده و نهایی ساخته نشده باشد → نهایی بساز
                elif last_stemmer and last_stemmer.date.end_date <= now() and (not last_final or last_final.date.start_date < last_stemmer.date.start_date):
                    date_final = get_or_create_datehalfyear("نهایی", final_duration)
                    report_card_final = ReportCard.objects.create(
                        person=person,
                        date=date_final,
                        title="نهایی",
                        average_score=round(random.uniform(10, 20), 2),
                        ring=ring
                    )
                    ReportCardFinaly.objects.create(
                        person=person,
                        title=report_card_final,
                        sargroh=None,
                        talimvatarbiat=None,
                        elmivaamozeshi=None,
                        varzeshivaordoee=None,
                        syasatgozari=None,
                        farmandehi=None,
                        emamjamaat=None,
                        upgrade_used=False
                    )


                # 🚀 حالت سوم: اگر نهایی تمام شده باشد → مستمر جدید بساز
                elif last_final and last_final.date.end_date <= now():
                    # شمارش دفعات مستمر
                    stemmer_count = ReportCard.objects.filter(person=person, title="مستمر").count()
                    if stemmer_count >= 3:  # اگر سه بار مستمر ایجاد شده باشد
                        date_final = get_or_create_datehalfyear("نهایی", final_duration)
                        report_card_final = ReportCard.objects.create(
                            person=person,
                            date=date_final,
                            title="نهایی",
                            average_score=round(random.uniform(10, 20), 2),
                            ring=ring
                        )
                        ReportCardFinaly.objects.create(
                            person=person,
                            title=report_card_final,
                            sargroh=None,
                            talimvatarbiat=None,
                            elmivaamozeshi=None,
                            varzeshivaordoee=None,
                            syasatgozari=None,
                            farmandehi=None,
                            emamjamaat=None,
                            upgrade_used=False
                        )
                    else:
                        date_stemmer = get_or_create_datehalfyear("مستمر", stemmer_duration)
                        report_card_stemmer = ReportCard.objects.create(
                            person=person,
                            date=date_stemmer,
                            title="مستمر",
                            average_score=round(random.uniform(10, 20), 2),
                            ring=ring
                        )
                        ReportCardFinaly.objects.create(
                            person=person,
                            title=report_card_stemmer,
                            sargroh=None,
                            talimvatarbiat=None,
                            elmivaamozeshi=None,
                            varzeshivaordoee=None,
                            syasatgozari=None,
                            farmandehi=None,
                            emamjamaat=None,
                            upgrade_used=False
                        )

            print("✅ کارنامه‌ها با موفقیت ساخته و چرخه‌ها اعمال شدند!")
        except Exception as e:
            print(f"❌ خطا در ایجاد کارنامه: {e}")
